<?php if (__FILE__ == $_SERVER['SCRIPT_FILENAME']) exit('No direct access allowed.');
 date_default_timezone_set("Asia/Calcutta");
//Initialize core objects

spl_autoload_register(function($class_name) {
	 require_once('libraries/' . $class_name. '.php');
});

$db = new Database();
$authentication = new Authentication();
$cart = new Cart();
$error = new Error();
$session = new Session();
$validate = new Validate();
$upload = new Upload();
$tpl = new Template(config_item('template', 'absolute_path'));
$item_per_page      = 5;
//Template values
$tpl->set('db', $db);
$tpl->set('authentication', $authentication);
$tpl->set('cart', $cart);
$tpl->set('error', $error);
$tpl->set('session', $session);

//session_regenerate_id(true);

$items_per_group =  config_item('cart', 'per_page_catalog');


function get_admin_record($bazar_id){
	
	global $db;
    $toady = date("Y-m-d"); 
	
	$sql = "SELECT 	* FROM bazar_record WHERE bazar_id = '" . $bazar_id . "' and record_date = '".$toady."' LIMIT 1";
	$records =  $db->fetch_row_assoc($sql);
	
	$open = ''; 
	$close = '';  
	
	if(!empty($records['open_number']) ){
		$open = $records['open_number'].' - '.$records['open_total'];
	}else{
		$open = '&#9733;&#9733;&#9733; - &#9733;'; 
	}
	
	if(!empty($records['close_number']) ){
		$close = $records['close_total'].' - '.$records['close_number'];
	}else{
		$close = '&#9733; - &#9733;&#9733;&#9733;'; 
	}
	
	$result = $open.' '.$close;
	return	$result;
}


function get_wallet_money($user_id){
    global $db;
    
    $sql = "SELECT user_wallet FROM users WHERE user_id = '" . $user_id . "'"; 
	$user_wallet =  $db->fetch_row_assoc($sql);
	
	return $user_wallet['user_wallet'];
	 
}

function get_final_admin_record($bazar_id,$record_date){
    global $db;
     
    
    $sql = "SELECT 	final_result FROM final_record WHERE bazar_id = '" . $bazar_id . "' and final_date = '".$record_date."' LIMIT 1"; 
	$final =  $db->fetch_row_assoc($sql);
	
	if($final['final_result'] != NULL){
	    return $final['final_result'];
	}else{
	    return "&#9733;";
	} 
}

function get_final_admin($bazar_id){
    global $db;
    $toady = date("Y-m-d");  
    
    $sql = "SELECT 	final_result FROM final_record WHERE bazar_id = '" . $bazar_id . "' and final_date = '".$toady."' LIMIT 1"; 
	$final =  $db->fetch_row_assoc($sql);
	
	if($final['final_result'] != NULL){
	    return $final['final_result'];
	}else{
	    return "&#9733;";
	} 
}

function get_final($bazar_name){
    global $db;
    $toady = date("Y-m-d"); 
    
    $yesterday = date('Y-m-d', strtotime('-1 day', strtotime($toady)));
    
    $sql = "SELECT 	final_result FROM final_record WHERE bazar_name = '" . $bazar_name . "' ORDER BY final_date DESC LIMIT 1"; 
 
	$final =  $db->fetch_row_assoc($sql);
	if($final['final_result'] != NULL){
	    return $final['final_result'];
	}else{
	    return "&#9733;";
	} 
}

function get_open($bazar_name){
    global $db;
    $toady = date("Y-m-d"); 
    
    $yesterday = date('Y-m-d', strtotime('-1 day', strtotime($toady)));
    
    $sql = "SELECT open_number,open_total FROM bazar_record WHERE bazar_name = '" . $bazar_name . "' ORDER BY record_date DESC LIMIT 1"; 
 
	$open =  $db->fetch_row_assoc($sql); 
	
	if($open['open_number'] != NULL){
	    return $open['open_number'].' - '.$open['open_total'];
	}else{
	    return "### - #";
	}
	
}

function get_startline_record($time,$starline_name){
    global $db;
    
    $sql = "SELECT starline_record_result, starline_record_total FROM starline_record WHERE starline_name = '".$starline_name."' and starline_record_time = '" . $time . "' and status = 1 ORDER BY id DESC LIMIT 1"; 
 
	$result =  $db->fetch_row_assoc($sql); 
	
	if($result['starline_record_result'] != NULL){
	    return $result['starline_record_result'].' - '.$result['starline_record_total'];
	}else{
	    return "&#9733;&#9733;&#9733; - &#9733;";
	} 	
}

function get_main_startline_final($time,$starline_name){
    global $db;
    $toady = date("Y-m-d");  
    $new_date =  date('Y-m-d', strtotime($toady. ' - 1 days')); 
    $sql = "SELECT starline_record_final FROM milan_starline_record WHERE starline_name = '".$starline_name."' and starline_record_time = '" . $time . "' and status = 1 ORDER BY id DESC LIMIT 1"; 
 
	$result =  $db->fetch_row_assoc($sql); 
	
	if($result['starline_record_final'] != NULL){
	    return $result['starline_record_final'];
	}else{
	    return "#";
	} 	
}

function get_milan_startline($time){
    global $db;
    $toady = date("Y-m-d");  
     
    $sql = "SELECT starline_record_result FROM milan_starline_record WHERE starline_record_time = '" . $time . "' and starline_record_date = '".$toady."' ORDER BY id DESC LIMIT 1"; 
 
	$result =  $db->fetch_row_assoc($sql); 
	
	if($result['starline_record_result'] != NULL){
	    return $result['starline_record_result'];
	}else{
	    return "### - #";
	} 	
}

function get_close($bazar_name){
    global $db;
    $toady = date("Y-m-d"); 
    
    $yesterday = date('Y-m-d', strtotime('-1 day', strtotime($toady)));
    
    $sql = "SELECT close_number,close_total FROM bazar_record WHERE bazar_name = '" . $bazar_name . "' ORDER BY record_date DESC LIMIT 1"; 
 
	$close =  $db->fetch_row_assoc($sql); 
	
	if($close['close_number'] != NULL){
	    return $close['close_number'].' - '.$close['close_total'];
	}else{
	    return "### - #";
	}
	
}

function get_user_name($user_id) {
	global $db;
	$sql = "SELECT user_name FROM users WHERE user_id = '" . $user_id . "'"; 
	$user_name =  $db->fetch_row_assoc($sql);
	return $user_name;
 
} 
function get_bazar_name($bazar_id) {
	global $db;
	$sql = "SELECT bazar_name FROM bazars WHERE bazar_id = '" . $bazar_id . "'"; 
	$bazar_name =  $db->fetch_row_assoc($sql);
	return $bazar_name;
 
}  
function get_user_mobile($user_id) {
		global $db;
		$sql = "SELECT user_mobile FROM users WHERE user_id = '" . $user_id . "'"; 
	    $user_mobile =  $db->fetch_row_assoc($sql); 
		return $user_mobile; 
}
function get_paper_image($bazar_id) {
		global $db;
	 $sql = "SELECT paper_image FROM bazar_papers WHERE bazar_id = '" . $bazar_id . "' ORDER BY id DESC Limit 1"; 
	    $paper_image =  $db->fetch_row_assoc($sql);
	    
		if($paper_image['paper_image'] == NULL){
		    return 0;
		}else{
		    return 'uploads/papers/'.$paper_image['paper_image'];
		} 
	
}

function get_profile_pic($user_id) {
		global $db;
		$sql = "SELECT profile_pic FROM user_profile WHERE user_id = '" . $user_id . "'"; 
	    $profile_pic =  $db->fetch_row_assoc($sql);
	    
		if($profile_pic['profile_pic'] == NULL){
		    return 'assets/images/profile-default.jpg';
		}else{
		    return 'uploads/profile-pics/'.$profile_pic['profile_pic'];
		} 
	
}

function get_social() {
		global $db;
		$social = array();
		foreach ($db->query("SELECT * FROM socialmedia") as $value) {
				$social[] =   $value;
	}		
	return $social;
}

/* shoaib 06/08/2017 get category */
function menu_categories($parent_id) {
		global $db;
		$sql1 = "SELECT id , category_name FROM menu_category WHERE id = '" . $parent_id . "'"; 
	 $menu_category =  $db->fetch_row_assoc($sql1);
							
		  return $menu_category;
	 	//var_dump( $menu_category);
	 	//var_dump( $menu_category);
	
}

/* get company name */
function get_company_name($accepted_id) {
		global $db;
	$sql1 = "SELECT companyName FROM international_entrepreneurs WHERE user_id = '" . $accepted_id . "'"; 
	$companyName =  $db->fetch_row_assoc($sql1);
							
		  return $companyName;
 
}
function get_company_name2($accepted_id) {
		global $db;
	$sql1 = "SELECT Company FROM regster_step WHERE user_id = '" . $accepted_id . "'"; 
	$Company =  $db->fetch_row_assoc($sql1);
							
		  return $Company;
 
}

/* get company name */

function user_name($parent_id) {
		global $db;
		$sql1 = "SELECT user_name FROM users WHERE user_id = '" . $parent_id . "'"; 
	    $user_name =  $db->fetch_row_assoc($sql1);
							
		  return $user_name;
	 	//var_dump( $menu_category);
	 	//var_dump( $menu_category);
	
}
function hotel_name($parent_id) {
		global $db;
		$sql1 = "SELECT HotelName FROM all_hotels WHERE id = '" . $parent_id . "'"; 
	    $HotelName =  $db->fetch_row_assoc($sql1);
							
		  return $HotelName; 
	
}

function user_email($parent_id) {
		global $db;
		$sql1 = "SELECT user_email FROM users WHERE user_id = '" . $parent_id . "'"; 
	    $user_email =  $db->fetch_row_assoc($sql1);
							
		  return $user_email;
	 	//var_dump( $menu_category);
	 	//var_dump( $menu_category);
	
}
function user_address($parent_id) {
		global $db;
		$sql1 = "SELECT user_address FROM users WHERE user_id = '" . $parent_id . "'"; 
	    $user_address =  $db->fetch_row_assoc($sql1);
							
		  return $user_address;
	 	//var_dump( $menu_category);
	 	//var_dump( $menu_category);
	
}
function item_id($parent_id) {
		global $db;
		$itemid = array();
		$sql1 = "SELECT item_id FROM cart WHERE order_id = '" . $parent_id . "'"; 
	    foreach ($db->query($sql1) as $value) 
	    {
	    	$itemid[] = array(
			 
			'item_id' =>$value['item_id']
		   );
	    }	
	//	var_dump($item_id);
	return $itemid;
	
}
function item_name($parent_id) {
		global $db;
		
		$sql1 = "SELECT item_name FROM menu_item WHERE id = '" . $parent_id . "'"; 
	    $itemname =  $db->fetch_row_assoc($sql1);
							
		return $itemname;
	
}

/* shoaib 06/08/2017 get category */


//Add new product
if (isset($_POST['add_product'])) {

	if (!empty($_POST['option']))
		$options = $_POST['option'];
	else
		$options = NULL;
						
	$cart->add_product($_POST['product_id'], $options);
	
}


//retrieve blog_tag name and id
function blog_tag()
{
	global $db;
	$sql="SELECT * FROM blog_tag ORDER BY name ASC";
	$data = array();
	foreach ($db->query($sql) as $value) 
	{
		$data[] = array(
			'id' =>$value['id'],
			'name' =>$value['name']
		);
	}	
	return $data;
}
//get new skills from user
function get_new_blogs($skill) {
		global $db;
		global $makDB; 
	
		//all skills from skills_tag
		$sql="SELECT name FROM `blog_tag`";
		
		  foreach ($db->query($sql) as $row)
		  {
			$allskills[] = strtolower($row['name']);
			//var_dump($row);exit();
		  }
		  //skills conversion
		  foreach($skill as $row)
		  {
		  $skills[] = strtolower($row);
		  }//var_dump($skills);
		  
		   $dif_skill=array_diff($skills,$allskills);
		   
		   foreach ($dif_skill as $val)
		   {
				$values['name'] =  $val;
				$db->insert('blog_tag', $values);
			}
}
function blogs_tag($j_id) {
	
	global $db;
	$result=$db->fetch_row_assoc("SELECT skill_learn FROM blog_post WHERE blog_id = '" . $j_id . "' limit 1");
	return $result['skill_learn'];
}

 
//Categories
function sub_categories($parent_id) {
	
	global $db;
	
	$categories = array();
	
	foreach ($db->query("SELECT category_id,parent_id, category_name,category_icon FROM " . config_item('cart', 'table_categories') . " WHERE parent_id = '" . $parent_id . "' ORDER BY category_name ASC ") as $value) {
							
		$categories[] = array(
			'category_id'	=> $value['category_id'], 
			'category_name'	=>  $value['category_name'],
			'category_icon'	=>  $value['category_icon'] 
		);
	}	
	
	return $categories;
}


 
//Logout
if (isset($_GET['logout']) && !$_POST) {

	$authentication->logout();

	header("Location: index.php");

}
 
 function area_count() {
	
	global $db;
	
	$area_count = array();
	
	foreach ($db->query("SELECT city_id FROM city where parent_id != 0") as $value) {
							
		$area_count[] =   $value;
	}	
	return $area_count;
}
 
function comment_count() {
	
	global $db;
	
	$comment_count = array();
	
	foreach ($db->query("SELECT comment_id FROM comment_system") as $value) {
							
		$comment_count[] =   $value;
	}	
	return $comment_count;
}
function comment_count_pen() {
	
	global $db;
	
	$comment_count_pen = array();
	
	foreach ($db->query("SELECT comment_id FROM comment_system where status=0") as $value) {
							
		$comment_count_pen[] =   $value;
	}	
	return $comment_count_pen;
}

function video_count() {
	
	global $db;
	
	$video_count = array();
	
	foreach ($db->query("SELECT video_id FROM video") as $value) {
							
		$video_count[] =   $value;
	}	
	return $video_count;
}

function video_count_pen() {
	
	global $db;
	
	$video_count = array();
	
	foreach ($db->query("SELECT video_id FROM video where video_status=0") as $value) {
							
		$video_count[] =   $value;
	}	
	return $video_count;
}

function gallery_count() {
	
	global $db;
	
	$gallery_count = array();
	
	foreach ($db->query("SELECT id FROM gallery") as $value) {
							
		$gallery_count[] =   $value;
	}	
	return $gallery_count;
}

function gallery_count_pen() {
	
	global $db;
	
	$gallery_count = array();
	
	foreach ($db->query("SELECT id FROM gallery where gallery_status=0") as $value) {
							
		$gallery_count[] =   $value;
	}	
	return $gallery_count;
}

function testimonials_limit() {
	
	global $db;
	
	$testimonals = array();
	
	foreach ($db->query("SELECT * FROM testimonals limit 7") as $value) {
							
		$testimonals[] =   $value;
	}	
	return $testimonals;
}

function testimonials() {
	
	global $db;
	
	$testimonals = array();
	
	foreach ($db->query("SELECT * FROM testimonals") as $value) {
							
		$testimonals[] =   $value;
	}	
	return $testimonals;
}


function product_count() {
	
	global $db;
	
	$product_count = array();
	
	foreach ($db->query("SELECT product_id FROM product") as $value) {
							
		$product_count[] =   $value;
	}	
	return $product_count;
}
$sql = "SELECT * FROM testimonals";
function product_count_pen() {
	
	global $db;
	
	$product_count = array();
	
	foreach ($db->query("SELECT product_id FROM product where product_status=0") as $value) {
							
		$product_count[] =   $value;
	}	
	return $product_count;
}

function customer_count() {
	
	global $db;
	
	$customer_count = array();
	
	foreach ($db->query("SELECT customer_id FROM customers") as $value) {
							
		$customer_count[] =   $value;
	}	
	return $customer_count;
}
function customer_count_pen() {
		global $db;
		$customer_count = array();	
	foreach ($db->query("SELECT user_id FROM users where user_status=0") as $value) {$customer_count[] =   $value;}	
	return $customer_count;
}

//count plan
function plan_count() {
		global $db; 
		$plan = array();
		foreach ($db->query("SELECT plan_id FROM plan") as $value) {$plan[] =   $value;}	
	return $plan;
}

//end count plan 
function news_count() {
		global $db; 	
	$news = array();	
	foreach ($db->query( "SELECT news_id FROM news") as $value) {$news[] =   $value;}	
	return $news;
}
//end count news

//plan
function our_plan() {
		global $db;
	$our_plan = array();
		foreach ($db->query("SELECT * FROM plan") as $value) {$our_plan[] =   $value;}	
	return $our_plan;
}//plan

//count banner
function banner_count() {
		global $db;
	$banner = array();
		foreach ($db->query("SELECT banner_id FROM banner") as $value) {$banner[] =   $value;}	
	return $banner;
}
//end count banner

if(isset($_GET['category_id']))	
$session->set('category_id',$_GET['category_id']);

//top Banner

function top_banner() {
		global $db;	
	foreach ($db->query("SELECT * FROM banner where banner_type='1' ORDER BY RAND()") as $value) {$top_banner[] =   $value;	}	
	return $top_banner;
}


//right Banner
function right_banner() {
		global $db;	
	$right_banner = array();	
	foreach ($db->query("SELECT * FROM banner where banner_type=2 ORDER BY RAND() limit 1") as $value) {$right_banner[] =   $value;}	
	return $right_banner;
}

//right Banner
function right_bottom_banner() {
		global $db;	
	$right_bottom_banner = array();	
	foreach ($db->query("SELECT * FROM banner where banner_type=4 ORDER BY RAND() limit 1") as $value) {$right_bottom_banner[] =   $value;}	
	return $right_bottom_banner;
}
//bottom Banner
function bottom_banner() {
		global $db;
		$bottom_banner = array();	
	foreach ($db->query("SELECT * FROM banner where banner_type=3 ORDER BY RAND() limit 1") as $value) {$bottom_banner[] =   $value;	}	
	return $bottom_banner;
}
//bottom Banner
function free_add() {
		global $db;
		$free_add = array();	
	foreach ($db->query("SELECT * FROM free_add where add_status=1 ORDER BY RAND() limit 10") as $value) {$free_add[] =   $value;	}	
	return $free_add;
}


function free_ad() {
		global $db;
		$free_add = array();	
	foreach ($db->query("SELECT * FROM free_add where add_status=1") as $value) {$free_add[] =   $value;	}	
	return $free_add;
}
//bottom Banner
function free_ad_pen() {
		global $db;
		$free_add = array();	
	foreach ($db->query("SELECT * FROM free_add where add_status=0") as $value) {$free_add[] =   $value;	}	
	return $free_add;
}

//Categories
function categories($parent_id) {
		global $db;
		$categories = array();
		foreach ($db->query("SELECT category_id,parent_id, category_name,category_icon FROM " . config_item('cart', 'table_categories') . " WHERE parent_id = '" . $parent_id . "' ORDER BY category_name ASC") as $value) {
							
		$categories[] = array(
			'category_id'	=> $value['category_id'],
			'parent_id'	=> $value['parent_id'],
			'category_name'	=>  $value['category_name'],
			'category_icon'	=>  $value['category_icon'] 
		);
	}	
	return $categories;
}
//city
function state($parent_id) {
		global $db;
		$city = array();
		foreach ($db->query("SELECT city_id, city_name FROM " . config_item('cart', 'table_city') . " WHERE parent_id = '" . $parent_id . "' ORDER BY city_name ASC") as $value) {
		$city[] = array(
			'city_id'	=> $value['city_id'],
			'city_name'	=>  $value['city_name']
		);
	}	
	return $city;
}

//city
function city($parent_id) {
		global $db;
		$city = array();
		foreach ($db->query("SELECT city_id, city_name FROM " . config_item('cart', 'table_city') . " WHERE parent_id = '" . $parent_id . "' ORDER BY city_name ASC") as $value) {
		$city[] = array(
			'city_id'	=> $value['city_id'],
			'city_name'	=>  $value['city_name']
		);
	}	
	return $city;
}


	function get_area() {
				global $db;
				$row_count_area = $db->row_count("SELECT city_id FROM " . config_item('cart', 'table_city')." where city_id = parent_id ");
				return $row_count_area;
	}

 


//Featured Company
function featured_comp() {
		global $db;
		$featured_comp = array();
		foreach ($db->query("SELECT * FROM customers c, plan p, users u where c.customer_package =p.plan_id && c.user_id=u.user_id && p.feature_company=1 && user_status=1 ORDER BY RAND() limit 10") as $value) {
							$featured_comp[] =   $value;
	}	
	return $featured_comp;
}



//Featured Product
function featured_product() {
		global $db;
		$featured_product = array();
		foreach ($db->query("SELECT * FROM customers c, plan p where c.customer_package =p.plan_id && p.feature_product=1 ORDER BY RAND() limit 10") as $value) {
							//$featured_product[] =   $value;
							foreach ($db->query("SELECT * FROM product pr where ". $value['user_id'] ." = pr.user_id limit ".$value['no_feature_product']) as $value) {
							$featured_product[] =   $value;
							}
							
							
	}	
	return $featured_product;
}


function footer() {
		global $db;
		$footer = array();
		foreach ($db->query("SELECT * FROM cms") as $value) {
				$footer[] =   $value;
	}		
	return $footer;
}

function news() {
		global $db;
		$news = array();
		foreach ($db->query("SELECT * FROM news Order by news_id DESC") as $value) {
				$news[] =   $value;
	}		
	return $news;
}

function advertise() {
		global $db;
		$advertise = array();
		foreach ($db->query("SELECT * FROM advertise") as $value) {
				$advertise[] =   $value;
	}		
	return $advertise;
}

/**
 * Load a config file
 */
function config_load($name) {
		
	$configuration = array();

	if (!file_exists(dirname(__FILE__) . '/config/' . $name . '.php'))
		die('The file ' . dirname(__FILE__) . '/config/' . $name . '.php does not exist.');

	require(dirname(__FILE__) . '/config/' . $name . '.php');
		
	if (!isset($config) OR !is_array($config))
		die('The file ' . dirname(__FILE__) . '/config/' . $name . '.php file does not appear to be formatted correctly.');
			
	if (isset($config) AND is_array($config))
		$configuration = array_merge($configuration, $config);
	
	return $configuration;

}

/**
 * Load a config item 
 */
function config_item($name, $item) {
	
	static $config_item = array();

	if (!isset($config_item[$item])) {
	
		$config = config_load($name);

		if (!isset($config[$item]))
			return FALSE;
	
		$config_item[$item] = $config[$item];
		
	}
	
	return $config_item[$item];

}

/**
 * Autoloading classes
 */
 /*
function __autoload($class_name) {

	require_once('libraries/' . $class_name . '.php');

}   */
 /* 

  */

/**
 * Get categories
 */				
function get_categories($category_id) {
	
	global $cart;
	
	$categories = $cart->get_categories($category_id);

	$output = '';
	
	if ($categories)
		$output  .= '<ul>';
		
	foreach ($categories as $row) {

		$sub_menu = '';
		
		$children = get_categories($row['category_id']);
			
		if (!empty($children))
			$sub_menu = '&bull;';
			
		$output .= '<li>';
		
		$output .= '<a href="category.php?category_id=' . $row['category_id'] . '"><span>' . $row['category_name'] . ' ' . $sub_menu . ' </span></a>';

		$output .= $children;
		
		$output .= '</li>';
		
	}
	
	if ($categories)
		$output .= '</ul>';
	
	return $output;
	
}

/**
 * Displays price with currency
 */
function price($price, $currency = NULL) {
	
	$currency_symbol = !is_null($currency) ? $currency : config_item('cart', 'currency_symbol');
	
	switch (config_item('cart', 'currency_position')) {
	
		case 'left':
			$price = $currency_symbol . ' ' . number_format($price, 2, '.', ',');
		break;
	
		case 'right':
			$price = number_format($price, 2, '.', ',') . ' ' . $currency_symbol;
		break;
		
	}
	
	return $price;
	
}
 
/**
 * Save the cart settings
 */
function save_config($config) {
	
	define('DIR_APPLICATION', str_replace('\'', '/', realpath(dirname(__FILE__))) . '/');
	
	$content = "";
	$content .= "<?php if (__FILE__ == \$_SERVER['SCRIPT_FILENAME']) exit('No direct access allowed.');\n\n";

	$content .= "\$config['table_users'] = 'users';\n";
	$content .= "\$config['table_groups'] = 'user_groups';\n";
	$content .= "\$config['table_profiles'] = 'user_profiles';\n\n";
		
	$content .= "\$config['site_title'] = '" . filter_var($config['site_title'], FILTER_SANITIZE_STRING) . "';\n\n";

	$content .= "\$config['site_url'] = '" . filter_var($config['site_url'], FILTER_SANITIZE_STRING) . "';\n\n";

	$content .= "\$config['absolute_path'] = '" . DIR_APPLICATION . "';\n\n";
	
	$content .= "\$config['admin_email'] = '" . $config['admin_email'] . "';\n\n";
	$content .= "\$config['admin_email_info'] = '" . $config['admin_email_info'] . "';\n\n";

	$content .= "\$config['default_group'] = 2;\n\n";

	$content .= "\$config['admin_group'] =  1;\n\n";

	if ($config['type_registration'] == 0) {
		
		$email_activation = "false";
		$approve_registration = "false";
	
	} else if ($config['type_registration'] == 1) {
		
		$email_activation = "true";
		$approve_registration = "false";
		
	} else if ($config['type_registration'] == 2) {
	
		$email_activation = "false";
		$approve_registration = "true";
	
	}
	
	$content .= "\$config['email_activation'] = " . $email_activation . ";\n\n";

	$content .= "\$config['approve_registration'] = " . $approve_registration . ";\n\n";

	$content .= "\$config['email_activation_expire'] = 60 * 60 * 24;\n\n";

	$content .= "\$config['email_subject_1'] = 'Thank you for registering';\n\n";

	$content .= "\$config['email_subject_2'] = 'New password';\n\n";

	$content .= "\$config['email_subject_3'] = 'A new customer has registered';\n\n"; 

	$content .= "\$config['email_subject_4'] = 'Your account has been approved';\n\n";
	
	$content .= "\$config['email_subject_5'] = 'A new member has been approved';\n\n";


	$content .= "\$config['user_expire'] = 3600 * 24 * 30;\n\n";

	$content .= "\$config['secret_word'] = '" . config_item('authentication', 'secret_word') . "';\n\n";
	

	$content .= "?>";

	file_put_contents("../config/authentication.php", $content, LOCK_EX);
	
	$content = "";
	$content .= "<?php if (__FILE__ == \$_SERVER['SCRIPT_FILENAME']) exit('No direct access allowed.');\n\n";

	$content .= "\$config['table_categories'] = 'categories';\n";
	$content .= "\$config['table_category_products'] = 'category_products';\n";
	$content .= "\$config['table_products'] = 'product';\n";
	$content .= "\$config['table_product_images'] = 'product_images';\n"; 
	$content .= "\$config['table_countries'] = 'countries';\n";
	$content .= "\$config['table_customers'] = 'customers';\n";
	$content .= "\$config['table_addresses'] = 'addresses';\n";        
	$content .= "\$config['table_banner'] = 'banner';\n\n";
	$content .= "\$config['table_city'] = 'city';\n\n";
	$content .= "\$config['table_plan'] = 'plan';\n\n";
	$content .= "\$config['table_video'] = 'video';\n\n";
	$content .= "\$config['table_users'] = 'users';\n\n";
	$content .= "\$config['table_comment_system'] = 'comment_system';\n\n";
	 
	
	$content .= "\$config['site_title'] = '" . filter_var($config['site_title'], FILTER_SANITIZE_STRING) . "';\n\n";

	$content .= "\$config['site_url'] = '" . filter_var($config['site_url'], FILTER_SANITIZE_STRING) . "';\n\n";

	$content .= "\$config['absolute_path'] = '" .DIR_APPLICATION . "';\n\n";
	
	$content .= "\$config['admin_email'] = '" . $config['admin_email'] . "';\n\n";
	
	$content .= "\$config['admin_email_info'] = '" . $config['admin_email_info'] . "';\n\n";

	$content .= "\$config['email_subject'] = 'Order received';\n\n";

	$content .= "\$config['per_page_catalog'] = " . $config['per_page_catalog'] . ";\n\n";

	$content .= "\$config['per_page_admin'] = " . $config['per_page_admin'] . ";\n\n";
	
	 

	$content .= "\$config['log_path'] = '" . DIR_APPLICATION . "logs/';\n\n";
			
	$content .= "\$config['new_order_notification'] = " . $config['new_order_notification'] . ";\n\n";
	
	$content .= "\$config['account_name'] = '" . filter_var($config['account_name'], FILTER_SANITIZE_STRING) . "';\n\n";
	$content .= "\$config['account_number'] = '" . filter_var($config['account_number'], FILTER_SANITIZE_STRING) . "';\n\n";
	$content .= "\$config['branch_name'] ='" . filter_var($config['branch_name'], FILTER_SANITIZE_STRING) . "';\n\n";
	$content .= "\$config['ifc'] = '" . filter_var($config['ifc'], FILTER_SANITIZE_STRING) . "';\n\n";
	$content .= "\$config['admin_mob'] = '" . filter_var($config['admin_mob'], FILTER_SANITIZE_STRING) . "';\n\n";

	$content .= "?>";

	file_put_contents("../config/cart.php", $content, LOCK_EX);

	$content = "";
	$content .= "<?php if (__FILE__ == \$_SERVER['SCRIPT_FILENAME']) exit('No direct access allowed.');\n\n";

	$content .= "\$config['upload_path'] = '" . DIR_APPLICATION . "uploads/';\n\n";

	/*$allowed_filetypes = '';
	
	foreach (config_item('upload', 'allowed_filetypes') as $value) {
			
			if (end(config_item('upload', 'allowed_filetypes')) === $value)
				$allowed_filetypes .= "'" . $value . "'";
			else
				$allowed_filetypes .= "'" . $value . "', ";
				
	}
			
	$content .= "\$config['allowed_filetypes'] = array(" . $allowed_filetypes . ");\n\n";*/

	$content .= "\$config['max_filesize'] = " . $config['max_filesize'] . ";\n\n";

	$content .= "\$config['max_width_thumbnail'] = " . $config['max_width_thumbnail'] . ";\n\n";

	$content .= "\$config['max_height_thumbnail'] = " . $config['max_height_thumbnail'] . ";\n\n";

	$content .= "\$config['max_width'] = " . $config['max_width'] . ";\n\n";

	$content .= "\$config['max_height'] = " . $config['max_height'] . ";\n\n";
	
	$content .= "?>";
	
	file_put_contents("../config/upload.php", $content, LOCK_EX);

	$content = "";
	$content .= "<?php if (__FILE__ == \$_SERVER['SCRIPT_FILENAME']) exit('No direct access allowed.');\n\n";

	$content .= "\$config['site_url'] = '" . filter_var($config['site_url'], FILTER_SANITIZE_STRING) . "';\n\n";
	
	$content .= "\$config['absolute_path'] = '" . DIR_APPLICATION . "templates/';\n\n";

	$content .= "\$config['template_extension'] = '.tpl';\n\n";
	
	$content .= "?>";
	
	file_put_contents("../config/template.php", $content, LOCK_EX);

}

?>
