<?php if (__FILE__ == $_SERVER['SCRIPT_FILENAME']) exit('No direct access allowed.');

/** 
 * Cart class
 */ 
class Cart {

	/**
	 * Config
	 *
	 * @access private 
	 */	
	private static $config;

	/**
	 * Database
	 *
	 * @access private 
	 */		
	private $db;

	/**
	 * Session
	 *
	 * @access private 
	 */		
	private $session;

	/**
	 * Error
	 *
	 * @access private 
	 */		
	private $error;
		
	/**
	 * Constructor
	 * 
	 * @access public 
	 */	  
	public function __construct() {
		
		self::$config = config_load('cart');
		
		$this->db = new Database();
		$this->session = new Session();
		$this->error = new Error();
		
		//$this->delete_carts();
		
		if (!$this->session->get('cart_session'))
			$this->cart_session();
		
	}

	/**
	 * Generates the session of the cart
	 * 
	 * @access private 
	 */	
	private function cart_session() {
		
		if (!$this->session->get('cart_session'))	
			$this->session->set('cart_session', md5(uniqid(mt_rand())));
		
	}
		
	/**
	 * Add product
	 * 
	 * @access public 
	 */	
	public function add_product($product_id, $options = array()) { }

	/**
	 * Get cart
	 * 
	 * @access public 
	 */	
	public function get_cart() { }

	/**
	 * Empty cart
	 * 
	 * @access public 
	 */	
	public function empty_cart() { }

	/**
	 * Remove item
	 * 
	 * @access public 
	 */	
	public function remove_item($cart_id, $product_id) { }

	/**
	 * Subtotal
	 * 
	 * @access public 
	 */
	public function subtotal() { }

	/**
	 * Shipping cost
	 * 
	 * @access public 
	 */
	public function shipping_cost() { }

	/**
	 * Tax rate
	 * 
	 * @access public 
	 */
	public function tax_rate() { }
			
	/**
	 * Total
	 * 
	 * @access public 
	 */
	public function total() { }

	/**
	 * Delete carts
	 * 
	 * @access private 
	 */
	public function get_user_contact($last_insert_id) {
		
		$result = $this->db->fetch_row_assoc("SELECT customer_mobile FROM " . self::$config['table_customers'] . " WHERE user_id = '" . $last_insert_id . "'");
	if (isset($result))
			return $result['customer_mobile'];
		 }
		 
		 
		 public function get_user_contact_by_email($email_id) {
		
		$result = $this->db->fetch_row_assoc("SELECT customer_mobile FROM " . self::$config['table_customers'] . " WHERE customer_email = '" . $email_id . "'");
			if (isset($result))
				return $result['customer_mobile'];
		 }
		 
		 
	    public function get_user_contact_name($email_id) {
		
		$result = $this->db->fetch_row_assoc("SELECT contact_person_name FROM " . self::$config['table_customers'] . " WHERE customer_email = '" . $email_id . "'");
			if (isset($result))
				return $result['contact_person_name'];
		 }
		 
		 public function get_plan_period($user_id) {
		
		$result = $this->db->fetch_row_assoc("SELECT customer_package FROM " . self::$config['table_customers'] . " WHERE user_id = '" . $user_id . "'");
		$result2 = $this->db->fetch_row_assoc("SELECT no_days FROM " . self::$config['table_plan'] . " WHERE plan_id = '" . $result['customer_package'] . "'");
		
			if (isset($result2))
				return $result2['no_days'];
		 }

	/**
	 * Get product
	 * 
	 * @access public 
	 */
	public function get_product($customer_id) {
		
		$customer_id = filter_var($customer_id, FILTER_SANITIZE_NUMBER_INT);
		
		$categories = array();
		
		foreach ($this->db->query("SELECT * FROM " . self::$config['table_products'] . " WHERE customer_id = '" . $category_id . "' AND category_status = 1 ORDER BY category_name ASC") as $row) {

			$categories[] = array(
				'category_id'	=> $row['category_id'],
				'category_name'	=> $row['category_name']
			);
			
		}

		return $categories;
		
		}

	/**
	 * Get product options
	 * 
	 * @access public 
	 */
	public function get_product_options($product_id) { }

	/**
	 * Get product images
	 * 
	 * @access public 
	 */
	public function get_product_images($product_id) { }

	/**
	 * Get products
	 * 
	 * @access public 
	 */
	public function get_products($category_id) { }

	/**
	 * Get categories
	 * 
	 * @access public 
	 */
	public function get_categories($category_id = 0) {
		
		$category_id = filter_var($category_id, FILTER_SANITIZE_NUMBER_INT);
		
		$categories = array();
		
		foreach ($this->db->query("SELECT * FROM " . self::$config['table_categories'] . " WHERE parent_id = '" . $category_id . "' AND category_status = 1 ORDER BY category_name ASC") as $row) {

			$categories[] = array(
				'category_id'	=> $row['category_id'],
				'category_name'	=> $row['category_name']
			);
			
		}

		return $categories;
		
	}
	
	
	/**
	 * Get category
	 * 
	 * @access public 
	 */
	public function get_category($category_id) {
		
		$category_id = filter_var($category_id, FILTER_SANITIZE_NUMBER_INT);
		
		foreach ($this->db->query("SELECT * FROM " . self::$config['table_categories'] . " WHERE category_id = '" . $category_id . "'") as $row) {

			$category = array(
				'category_id'	=> $row['category_id'],
				'category_name'	=> $row['category_name']
			);
			
		}
		
		if (isset($category))
			return $category;
		
	}
	
 
	public function get_category_name($category_id) {
	$result = $this->db->fetch_row_assoc("SELECT category_name FROM " . self::$config['table_categories'] . " WHERE category_id = '" . $category_id . "'");
	if (isset($result))
			return $result['category_name'];
	}
	
	public function get_sub_category($sub_category) {
	$result = $this->db->fetch_row_assoc("SELECT category_name FROM " . self::$config['table_categories'] . " WHERE category_id = '" . $sub_category . "'");
	if (isset($result))
			return $result['category_name'];
	}

	public function get_city_name($city_id) {
	$result = $this->db->fetch_row_assoc("SELECT city_name FROM " . self::$config['table_city'] . " WHERE city_id = '" . $city_id . "'");
	if (isset($result))
			return $result['city_name'];
	}
	
	public function get_area($area) {
	$result = $this->db->fetch_row_assoc("SELECT city_name FROM " . self::$config['table_city'] . " WHERE city_id = '" . $area . "'");
	if (isset($result))
			return $result['city_name'];
			
	}
	public function get_customer_id($user_id) {
	$result = $this->db->fetch_row_assoc("SELECT customer_id FROM " . self::$config['table_customers'] . " WHERE  user_id = '" . $user_id . "'");
	if (isset($result))
			return $result['customer_id'];
			
	}
	
	public function get_plan_price($plan_id) {
	$result = $this->db->fetch_row_assoc("SELECT plan_price FROM " . self::$config['table_plan'] . " WHERE plan_id = '" . $plan_id . "'");
	if (isset($result))
			return $result['plan_price'];
	}
	
	
public function get_logo() {
	$result = $this->db->fetch_row_assoc("SELECT image FROM logo");
	if (isset($result))
			return $result['image'];
	}

	public function get_video($user_id) {
		
		//$user_id = filter_var($user_id, FILTER_SANITIZE_NUMBER_INT);
		$video=array();
		foreach ($this->db->query("SELECT * FROM " . self::$config['table_video'] . " WHERE user_id = '" . $user_id . "'") as $row) {

			$video = array(
				'video_id'	=> $row['video_id'],
				'video_file'	=> $row['video_file']
			);
			
		}
		
		if (isset($video))
			return $video;
		
	}
	
public function no_feature_product($user_id)
		
{
	global $db;
	$no_feature_product=$db->fetch_row_assoc("SELECT p.no_product FROM " . config_item('cart', 'table_customers') . " c, " . config_item('cart', 'table_plan') . " p WHERE c.user_id = '" . $user_id . "' AND c.customer_package = p.plan_id");
	
	
		if (isset($no_feature_product))
			return $no_feature_product['no_product'];
}

public function get_count_product($user_id)
{
	global $db;
	$get_count_product=$db->fetch_row_assoc("SELECT COUNT(product_id) as count_id FROM " . config_item('cart', 'table_products') . " WHERE user_id = '" . $user_id . "'");
	 
	if (isset($get_count_product))
			return $get_count_product['count_id']; 
}

public function no_feature_video($user_id)
		
{
	global $db;
	$no_feature_product=$db->fetch_row_assoc("SELECT p.product_video FROM " . config_item('cart', 'table_customers') . " c, " . config_item('cart', 'table_plan') . " p WHERE c.user_id = '" . $user_id . "' AND c.customer_package = p.plan_id");
	
	
		if (isset($no_feature_product))
			return $no_feature_product['product_video'];
}

public function get_count_video($user_id)
{
	global $db;
	$get_count_product=$db->fetch_row_assoc("SELECT COUNT(video_id) as video_id FROM " . config_item('cart', 'table_video') . " WHERE user_id = '" . $user_id . "'");
	 
	if (isset($get_count_product))
			return $get_count_product['video_id']; 
}

public function no_feature_image($user_id)
		
{
	global $db;
	$no_feature_product=$db->fetch_row_assoc("SELECT p.product_image FROM " . config_item('cart', 'table_customers') . " c, " . config_item('cart', 'table_plan') . " p WHERE c.user_id = '" . $user_id . "' AND c.customer_package = p.plan_id");
	
	
		if (isset($no_feature_product))
			return $no_feature_product['product_image'];
}
public function get_count_image($user_id)
{
	global $db;
 
	$get_count_product=$db->fetch_row_assoc("SELECT COUNT(id) as gall_id FROM gallery WHERE user_id = '" . $user_id . "'");
	 
	if (isset($get_count_product))
			return $get_count_product['gall_id']; 
}

public static function send($data,$mobile){
$mobile=trim($mobile);
$curl_scraped_page=''; 
$data=urlencode($data); 

$url="http://sms.bhashsms.com/api/sendmsg.php?user=saudicompare&pass=123456&sender=umrahs&phone=".$mobile;
// add the message
$url.="&text=".$data;
// Add the message type, api user id, api password, and message mask word
$url.="&priority=ndnd&stype=normal";



/*$url="http://sms.bhashsms.com/api/sendmsg.php?user=saudicompare&pass=123456&sender=umrahs&phone=7977146370&text=test&priority=ndnd&stype=normal";*/
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$curl_scraped_page = curl_exec($ch);
curl_close($ch);

//$curl_scraped_page="success | 91123456789 | 22***************-29***************";
return $curl_scraped_page;
}
	/**
	 * Has shipping
	 * 
	 * @access public 
	 */
	public function has_shipping() {}
	
	/**
	 * Update cart
	 * 
	 * @access public 
	 */
	public function update_cart($cart_id, $product_id, $quantity) {}

	/**
	 * Check coupon
	 * 
	 * @access public 
	 */	
	public function check_coupon($coupon_code) { }

	/**
	 * Get coupon
	 * 
	 * @access public 
	 */	
	public function get_coupon($coupon_id) { }
	
	/**
	 * Checkout
	 * 
	 * @access public 
	 */	
	public function checkout($user_id, $user_email, $payment_method, $comment = NULL) { }
	
		
}

?>
