<?php require_once('header' . config_item('template', 'template_extension')); ?>

<style>
table h1, table h2, table h3, table h4, table h5, table h6 {
    font-size: 14px;
    font-weight: 100;
}
</style>

<style>
.card {
    box-shadow: 0 4px 8px 0 rgb(0 0 0 / 20%);
    transition: 0.3s;
    width: 100%;
    overflow: hidden;
    padding: 15px;
    margin: 5px 0px;
}

.card:hover {
  box-shadow: 0 8px 16px 0 rgba(0,0,0,0.2);
}


.container_inner h4 {
    text-align: center;
    text-transform: uppercase;
    margin-bottom: 10px;
    font-size: 18px;
    color: #1b1990;
}

p.main_no {
    text-align: center;
    margin: 0px 0px 5px 0px;
    letter-spacing: 3px;
    font-size: 20px;
    font-weight: 600;
    color: red;
    line-height: 22px;
}

p.final_no {
    text-align: center;
    font-size: 20px;
    font-weight: 600;
    color: black;
    line-height: 20px;
    margin-bottom: 5px;
}

span.open_time {}

p.time {
    font-size: 12px;
    margin-bottom: 10px;
    overflow: hidden;
}

span.open_time {
    float: left;
    text-decoration: underline;
}

span.close_time {
    float: right;
    text-decoration: underline;
}

.switch-field {
    display: flex;
    margin-bottom: 15px;
    overflow: hidden;
}

.switch-field input {
	position: absolute !important;
	clip: rect(0, 0, 0, 0);
	height: 1px;
	width: 1px;
	border: 0;
	overflow: hidden;
}

.switch-field label {
	background-color: #e4e4e4;
	color: rgba(0, 0, 0, 0.6);
	font-size: 14px;
	line-height: 1;
	text-align: center;
	padding: 8px 16px;
	margin-right: -1px;
	border: 1px solid rgba(0, 0, 0, 0.2);
	box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.3), 0 1px rgba(255, 255, 255, 0.1);
	transition: all 0.1s ease-in-out;
}

.switch-field label:hover {
	cursor: pointer;
}

.switch-field input:checked + label {
	background-color: #a5dc86;
	box-shadow: none;
}

.switch-field label:first-of-type {
	border-radius: 4px 0 0 4px;
}

.switch-field label:last-of-type {
	border-radius: 0 4px 4px 0;
}
.buttons {
    width: 50%;
    float: left;
}
.last_line {
    font-size: 14px;
    text-align: center;
    margin: 0px;
}
.report-links {
    margin: 10px;
}
.report-sheet {
    float: right;
    font-size: 12px;
    margin-top: 5px;
    color: white;
    font-weight: 400;
    border: 1px solid #ccc;
    padding: 2px 10px;
    background: #b62322;
    letter-spacing: 1px;
}
.report-sheet:hover {
    color: white;
    text-decoration: none;
    background: #140e7b;
}
</style>

<section id="main-content">

<div class="backdrop" style="display:none">
	<img src="images/loader.gif" class="loader">
</div>

<section class="wrapper">
	<section class="dtbl-sec"> 
		<div class="container">
			<div class="row">
				<div class="col-md-12">
					<div class="heading-main"> <h3> Today's Record - <?php echo date('d F, Y (l)'); ?></h3> </div>
				</div>
				<?php  foreach($bazarList as $value){ ?>
				<div class="col-md-3">
					<div class="card" <?php if($value['is_yellow']){ echo 'style="background:yellow"'; } ?>> 
						<div class="container_inner">
							<h4><b><?php echo $value['bazar_name']; ?></b></h4> 
							<p class="main_no"><?php echo get_admin_record($value['bazar_id']); ?></p> 
							<p class="final_no"><?php echo get_final_admin($value['bazar_id']); ?></p> 
							<p class="time">
								<span class="open_time">Open - <?php echo $value['open_time']; ?></span>
								<span class="close_time">Close <?php echo $value['close_time']; ?></span>
							</p>
							
							<div class="buttons">
							
								<button class="btn btn-primary left add-open-record" title="Add Open Record" data-id="<?php echo $value['bazar_id']; ?>" > <i class="fa fa-plus" aria-hidden="true"></i> O </button>
								
								<button class="btn btn-primary left add-close-record" title="Add Close Record" data-id="<?php echo $value['bazar_id']; ?>" > <i class="fa fa-plus" aria-hidden="true"></i> C </button>
								
								<!--<button class="btn btn-primary right edit-record" data-id="<?php echo $value['bazar_id']; ?>"  title="Edit Record" > <i class="fa fa-pencil-square-o" aria-hidden="true"></i> </button> 
								-->
							</div> 
							
							<div class="switch-field">
							
								<input type="radio" class="bet_play" data-id="<?php echo $value['bazar_id']; ?>" id="radio-one-<?php echo $value['bazar_id']; ?>" name="bet_play_<?php echo $value['bazar_id']; ?>" value="1" <?php if($value['bet_play'] == 1){echo "checked";}?> >
								<label for="radio-one-<?php echo $value['bazar_id']; ?>">ON</label>
								
								<input type="radio" class="bet_play" data-id="<?php echo $value['bazar_id']; ?>" id="radio-two-<?php echo $value['bazar_id']; ?>" name="bet_play_<?php echo $value['bazar_id']; ?>" value="0" <?php if($value['bet_play'] == 0){echo "checked";}?> />
								<label for="radio-two-<?php echo $value['bazar_id']; ?>">OFF</label>
								
							</div> 
							
							<?php if($value['bet_play'] == 0){ ?>
							<p class="last_line red-txt"> Betting is closed for today </p>
							<?php }else if($value['bet_play'] == 1){ ?>
							<p class="last_line green-txt"> Betting is runing for today </p> 
							<?php } ?>
							
							<a href="javasript:void(0);" class="report-sheet" data-id="<?php echo $value['bazar_id']; ?>"> Report Sheet</a>
							
						</div>
					</div>
				</div>
				<?php } ?>
				
			</div>
		</div>	 
	</section>
</section>

<?php require_once('footer' . config_item('template', 'template_extension')); ?>
<script>
$(document).ready(function(){
	
	$(".bet_play").change(function () { 
		var bazar_id = $(this).attr('data-id'); 
		var bet_play = $(this).val();
		
		$(".backdrop").show();
		formData = {};
		formData.change_bazar_status = true;
		formData.bazar_id = bazar_id; 
		formData.bet_play = bet_play;
 	 
		$.ajax({
			type: "POST",
			url:  "index.php",
			data: formData,
			cache: false,
			success: function(html) {   
				location.reload(); 
			}, 
	    });
	}); 
	
	$(".add-open-record").click(function(){  
	formData = {};
 	formData.get_bazar_name = true;
 	formData.bazar_id = $(this).attr('data-id'); 
 	 
		$.ajax({
			type: "POST",
			url:  "index.php",
			data: formData,
			cache: false,
			success: function(html) {  
				var result = JSON.parse(html);
				$('.bazar-name-get').html(result.bazar_name);
				$('.bazar_id_get').html(result.bazar_id);
				$("#add-open-records").modal('toggle');   
			}, 
	    });
	
    });
    
    $(".add-close-record").click(function(){  
	formData = {};
 	formData.get_bazar_name = true;
 	formData.bazar_id = $(this).attr('data-id'); 
 	 
		$.ajax({
			type: "POST",
			url:  "index.php",
			data: formData,
			cache: false,
			success: function(html) {  
				var result = JSON.parse(html);
				$('.bazar-name-get').html(result.bazar_name);
				$('.bazar_id_get').html(result.bazar_id);
				$("#add-close-records").modal('toggle');   
			}, 
	    });
	
    });
    
    
    $(".report-sheet").click(function(){  
	formData = {};
 	formData.get_bazar_report = true;
 	formData.bazar_id = $(this).attr('data-id'); 
 	 
		$.ajax({
			type: "POST",
			url:  "index.php",
			data: formData,
			cache: false,
			success: function(html) {  
				var result = JSON.parse(html);
				$('.bazar-name-get').html(result.bazar_name);
				$('.bazar_id_report_sheet').html(result.report_link);
				$("#show-report-sheet").modal('toggle');   
			}, 
	    });
	
    });
	
});
</script>


<div class="modal fade" id="show-report-sheet" role="dialog">
    <div class="modal-dialog"> 
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header"> 
		<button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Show Report Sheet</h4> 
        </div>
        <div class="modal-body" >  
			<form action="" method="post">
				<div class="row">
				<div class="col-md-12 mb-12">
					<div class="pkg-flds">
						<h3 ><span class="bazar-name-get"></span> - Report Sheet</h3> 
					</div>  
				</div>  
				<div class="col-md-12 mb-12">
					 <div class="bazar_id_report_sheet" ></div>
				</div>   
			    </div>
			</form> 
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button> 
        </div>
      </div> 
    </div>
 </div>


<div class="modal fade" id="add-open-records" role="dialog">
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header"> 
		<button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Add Open Record</h4> 
        </div>
        <div class="modal-body" >  
			<form action="" method="post">
				<div class="row">
				<div class="col-md-12 mb-12">
					<div class="pkg-flds">
						<h3 ><span class="bazar-name-get"></span> - Add Open Record</h3> 
					</div>  
				</div>  
				<div class="col-md-6 mb-12">
					<div class="pkg-flds">
					<label for="open_number"> </label><br>
					<input type="text" class="form-control is-valid record_number" id="open_number" name="open_number" placeholder="123">
					<input type="text" class="form-control is-valid record_total" id="open_total" name="open_total" placeholder="6">
					</div>
				</div>  
			<div class="bazar_id_get" ></div>
			 
			<div class="col-md-12 mb-12 mg-top-15">
			<div class="form-group"> 
				<input type="submit" class="btn btn-success" name="add_open_record" value="Add Open Record"> 
			</div>
			</div>
			</div>
			</form>
		
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button> 
        </div>
      </div>
      
    </div>
 </div>
  
 
<div class="modal fade" id="add-close-records" role="dialog">
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header"> 
		<button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title">Add Close Record</h4> 
        </div>
        <div class="modal-body" > 
		
			<form action="" method="post">
				<div class="row">
				<div class="col-md-12 mb-12">
					<div class="pkg-flds">
						<h3 ><span class="bazar-name-get"></span> - Add Close Record</h3> 
					</div>  
				</div>  
				<div class="col-md-6 mb-12">
					<div class="pkg-flds">
					<label for="close_number"> </label><br>
					<input type="text" class="form-control is-valid record_number" id="close_number" name="close_number" placeholder="123">
					<input type="text" class="form-control is-valid record_total" id="close_total" name="close_total" placeholder="6">
					</div>
				</div>  
			<div class="bazar_id_get" ></div>
			 
			<div class="col-md-12 mb-12 mg-top-15">
			<div class="form-group"> 
				<input type="submit" class="btn btn-success" name="add_close_record" value="Add Close Record"> 
			</div>
			</div>
			</div>
			</form>
		
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button> 
        </div>
      </div>
      
    </div>
 </div>