<?php if (__FILE__ == $_SERVER['SCRIPT_FILENAME']) exit('No direct access allowed.');

/** 
 * Authentication class
 */ 
require 'phpmailer/PHPMailerAutoload.php';
class Authentication {

	/**
	 * Config
	 *
	 * @access private 
	 */	
	private static $config;

	/**
	 * Database
	 *
	 * @access private 
	 */		
	private $db;

	/**
	 * Session
	 *
	 * @access private 
	 */		
	private $session;
	
	/**
	 * Constructor
	 * 
	 * @access public 
	 */	  
	public function __construct() {
		
		self::$config = config_load('authentication');
		
		$this->db = new Database();
		$this->session = new Session();
		$this->cart = new Cart();
		
		$this->auto_login();
		
		/* $this->delete_inactive_users(); */
		
	}

	/**
	 * Create user
	 * 
	 * @access public 
	 */		
	public function register($user_name, $user_mobile,$user_email, $user_password) {
 
				$user_password = filter_var($user_password, FILTER_SANITIZE_STRING);
								
			    $sql = "SELECT * FROM users WHERE user_mobile = '" . $user_mobile . "' OR user_email = '" . $user_email . "' ";
				
				if ($this->db->row_count($sql)) {
				    
					// Email or mobile number already exists
					return false;
				}
				
				$values = array(
						'user_name'			     => $user_name, 
						'user_mobile'			 => $user_mobile, 
					 	'user_password'    	     => $user_password,
					 	'user_email'          => $user_email,
						'user_status' 			 => 1
				);
			  	 
		    $this->db->insert('users', $values);
		
		    $user_id = $this->db->last_insert_id(); 
		    
		    $values2 = array(
						'user_id'			     => $user_id
				);
			
			$this->db->insert('user_profile', $values2);
		    
		    $sql = "SELECT * FROM users WHERE user_id = '" . $user_id . "'";
		
		if ($this->db->row_count($sql)) {
			
			session_regenerate_id(true);
			$this->session->set('token', $this->token());
			$this->session->set('logged_in', true); 
			
			$result = $this->db->fetch_row_assoc($sql);
			$this->session->set('user_id', $result['user_id']);  
			$this->session->set('user_mobile', $result['user_mobile']);
			$this->session->set('user_name', $result['user_name']);
			$this->session->set('user_email', $result['user_email']);
			$this->session->set('user_wallet', $result['user_wallet']);
		   
				 
			return true;
			
		} else {

			return false;

		}
		    
	}
	
	
	public function login($user_mobile, $user_password) {
		 
		$password = filter_var($user_password, FILTER_SANITIZE_STRING);
		
		$sql = "SELECT * FROM users WHERE user_mobile = '" . $user_mobile . "' AND user_password = '" . $password . "' AND user_status = 1";
		
		if ($this->db->row_count($sql)) {
			
			session_regenerate_id(true);
			$this->session->set('token', $this->token());
			$this->session->set('logged_in', true); 
			
			$result = $this->db->fetch_row_assoc($sql);
			$this->session->set('user_id', $result['user_id']);  
			$this->session->set('user_mobile', $result['user_mobile']);
			$this->session->set('user_name', $result['user_name']);
			$this->session->set('user_wallet', $result['user_wallet']);
			$this->session->set('user_email', $result['user_email']);
			$this->session->set('user_type', $result['user_type']);
		   
				 
			return true;
			
		} else {

			return false;

		}
		
	}
	
	
	
	/**
	 * Update user
	 * 
	 * @access public 
	 */		
	
	
		/**
	 * Update user
	 * 
	 * @access public 
	 */		
	

	/**
	 * Get user
	 * 
	 * @access public 
	 */	
	public function get_user($user_id) {
	
		foreach ($this->db->query("SELECT * FROM " . self::$config['table_users'] . " users, " . self::$config['table_profiles'] . " profiles WHERE users.user_id = '" . $user_id . "' AND profiles.user_id = '" . $user_id . "'") as $row) {
						
			$user = array(
				'user_id'				=> $row['user_id'],
				'group_id'				=> $row['group_id'],
				'user_name'				=> $row['user_name'],
				'user_email'			=> $row['user_email'],
 				'user_mobile'			=> $row['user_mobile'],
				'user_status'			=> $row['user_status']
			);
							
        }
		
		return $user;		
	
	}

	/**
	 * Get active users
	 * 
	 * @access public 
	 */	
	public function get_active_users() {

		foreach ($this->db->query("SELECT * FROM " . self::$config['table_users'] . " users, " . self::$config['table_profiles'] . " profiles WHERE profiles.user_id = users.user_id AND users.user_status = 1") as $row) {
						
			$users[] = array(
				'user_id'				=> $row['user_id'], 
				'contact_person_name'	=> $row['contact_person_name'], 
				'user_email'			=> $row['user_email']
			);
							
        }
		
		if (isset($users))
			return $users;

	}

	/**
	 * Get inactive users
	 * 
	 * @access public 
	 */	
	public function get_inactive_users() {

		foreach ($this->db->query("SELECT * FROM " . self::$config['table_users'] . " users, " . self::$config['table_profiles'] . " profiles WHERE profiles.user_id = users.user_id AND users.user_status = '0'") as $row) {
						
			$users[] = array(
				'user_id'		=> $row['user_id'],
				'contact_person_name'	=> $row['contact_person_name'],  
				'user_email'	=> $row['user_email']
			);
							
        }
		
		if (isset($users))
			return $users;

	}

	/**
	 * Get newest users
	 * 
	 * @access public 
	 */	
	public function get_newest_users($limit = 10) {
	
		foreach ($this->db->query("SELECT * FROM " . self::$config['table_users'] . " users, " . self::$config['table_profiles'] . " profiles WHERE profiles.user_id = users.user_id AND users.user_status = 1 ORDER BY user_created DESC LIMIT " . $limit . "") as $row){
						
			$users[] = array(
				'user_id'		=> $row['user_id'], 
				'contact_person_name'	=> $row['contact_person_name'], 
				'user_email'	=> $row['user_email'],
				'user_status'	=> $row['user_status'],
				'last_login'	=> $row['last_login']
			);
							
        }
		
		if (isset($users))
			return $users;			
	
	}

	/**
	 * Activate user
	 * 
	 * @access public 
	 */	
	public function activate_user($email, $code) {

		$email = filter_var($email, FILTER_SANITIZE_EMAIL);
		$code = filter_var($code, FILTER_SANITIZE_STRING);
		
		if ($this->db->row_count("SELECT activation_code FROM " . self::$config['table_users'] ." WHERE user_email = '" . $email . "' AND activation_code = '" . $code . "'")) {
			
			$values = array(
				'activation_code' 	=> '',
				'user_status' 		=> 1,
				'user_approved' 	=> 1
			); 			

			$where = array(
				'user_email' => $email
			);
			
			$this->db->where($where);
			$this->db->update(self::$config['table_users'], $values);
						
			return true;
			
		} else {

			return false;
						
		}
	
	}

	/**
	 * Token
	 * 
	 * @access private 
	 */	
	private function token() {
			
		return md5(self::$config['secret_word'] . $_SERVER['REMOTE_ADDR'] . $_SERVER['HTTP_USER_AGENT']);
		
	}
	
	/**
	 * Login
	 * 
	 * @access public 
	 */	
	 
	
	
	
	
	public function agent_login($email, $password) {

		$email = filter_var($email, FILTER_SANITIZE_EMAIL);
		$password = filter_var($password, FILTER_SANITIZE_STRING);
		
		
		$sql = "SELECT * FROM psa_agent WHERE user_email = '" . $email . "' AND user_password = '" . sha1($password) . "' AND status = 1  ";
		
		if ($this->db->row_count($sql)) {
			
			session_regenerate_id(true);
			$this->session->set('token', $this->token());
			$this->session->set('logged_in', true);
			
			$result = $this->db->fetch_row_assoc($sql);
			$this->session->set('psa_id', $result['psa_id']); 
			$this->session->set('user_email', $result['user_email']);  
			   
				
			return true;
			
		} else {

			return false;

		}
		
	}
	
	
	
	/* activate user */
	
		public function activate_mail_send($user_id) {

		 
		if ($this->db->row_count("SELECT user_email,user_id FROM " . self::$config['table_users'] ." WHERE user_id = '" . $user_id . "'")) {
					
				$sql = "SELECT * FROM " . self::$config['table_users'] ." WHERE user_id = '" . $user_id . "'";
				$result = $this->db->fetch_row_assoc($sql); 
			$password = substr(md5(uniqid(rand())), 0, 8);
			$login_id = substr(uniqid(rand()), 0, 5);
            $login_id = 	$login_id.$user_id;
			$where = array(
				'user_id' => $user_id
			);
			
			$this->db->where($where);
			$this->db->update(self::$config['table_users'], 
			array( 'user_password' => sha1($password), 'login_id' => $login_id ));
							
		 	$headers  = 'From: ' . self::$config['site_title'] . '<' . self::$config['admin_email'] . '>' . "\r\n";
			$headers .=	'Reply-To: ' . self::$config['admin_email'] . "\r\n";
			$headers .=	'X-Mailer: PHP/' . phpversion();
			$headers .= 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
		 
			$message = file_get_contents(self::$config['absolute_path'] . 'templates/mail/user_approved.tpl');
			$message = str_replace('%%PASSWORD%%', $password, $message);
			$message = str_replace('%%LOGINID%%', $login_id, $message);
			$message = str_replace('%%SITE_TITLE%%', self::$config['site_title'], $message);
			$message = str_replace('%%SITE_URL%%', self::$config['site_url'], $message);
			$message = str_replace('%%USER_NAME%%', $result['user_name'], $message); 
			
			
				 
		 
		 mail($result['user_email'], self::$config['email_subject_2'], $message, $headers);
		 mail('info@umrahconnect.com', 'New Franchisee Account is Approved ', $message, $headers);
		
		
		  
			return true;
			
		} else {
		
			return false;
			
		}
	
	}

	
	/* activate user */
	  
	
	/* new user activation */  
		public function user_account_mail($email,$name,$ticketno) {

		 			
			$headers  = 'From: ' . self::$config['site_title'] . '<' . self::$config['admin_email'] . '>' . "\r\n";
			$headers .=	'Reply-To: ' . self::$config['admin_email'] . "\r\n";
			$headers .=	'X-Mailer: PHP/' . phpversion();
			$headers .= 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";

			$message = file_get_contents(self::$config['absolute_path'] . 'templates/mail/new_activation_mail.tpl');
			$message = str_replace('%%USER_NAME%%', $name, $message);
			$message = str_replace('%%TICKECTNO%%', $ticketno, $message); 
			$message = str_replace('%%SITE_TITLE%%', self::$config['site_title'], $message);
			$message = str_replace('%%SITE_URL%%', self::$config['site_url'], $message);  
		 
		 
			mail($email, 'Account Activation Process for Umrah Connect', $message, $headers);
			
			return true;
			
		 
	}

	
	/* new user activation */
	
	
/* new user admin */  
		public function user_account_admin_mail($user_id) {

		 
		if ($this->db->row_count("SELECT * FROM " . self::$config['table_users'] ." WHERE user_id = '" . $user_id . "'")) {
					
			$sql = "SELECT * FROM " . self::$config['table_users'] ." WHERE user_id = '" . $user_id . "'";
			$result = $this->db->fetch_row_assoc($sql);
			 			
			$headers  = 'From: ' . self::$config['site_title'] . '<' . self::$config['admin_email'] . '>' . "\r\n";
			$headers .=	'Reply-To: ' . self::$config['admin_email'] . "\r\n";
			$headers .=	'X-Mailer: PHP/' . phpversion();
			$headers .= 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";

			$message = file_get_contents(self::$config['absolute_path'] . 'templates/mail/new_user.tpl');
			$message = str_replace('%%NAME%%', $result['user_name'], $message);
			$message = str_replace('%%EMAIL%%', $result['user_email'], $message);
			$message = str_replace('%%MOBILE%%', $result['user_mobile'], $message);
			$message = str_replace('%%AADHAR%%', $result['aadharno'], $message);
			$message = str_replace('%%PANNO%%', $result['panno'], $message);
			$message = str_replace('%%PASSPORTNO%%', $result['passportno'], $message);
			$message = str_replace('%%ADDRESS%%', $result['user_address'], $message);
			$message = str_replace('%%CITY%%', $result['city'], $message);
			$message = str_replace('%%STATE%%', $result['state'], $message);
			$message = str_replace('%%PINCODE%%', $result['pincode'], $message);
			
			
			$message = str_replace('%%SITE_TITLE%%', self::$config['site_title'], $message);
			$message = str_replace('%%SITE_URL%%', self::$config['site_url'], $message);  
		 
		 
			mail('info@umrahconnect.com', 'New User Registered From Android Application', $message, $headers);
	        
			return true;
			
		} else {
		
			return false;
			
		}
	
	}

	
	/* new user admin*/
	

	/**
	 * Login
	 * 
	 * @access public 
	 */	
	public function admin_login($email, $password, $remember = false) {

		$email = filter_var($email, FILTER_SANITIZE_STRING);
		$password = filter_var($password, FILTER_SANITIZE_STRING);
		
		$sql = "SELECT * FROM admin  WHERE user_name = '" . $email . "' AND admin_password = '" . $password . "' AND status = 1";
		
		 
		 
		if ($this->db->row_count($sql)) {
			
			session_regenerate_id(true);
			$result = $this->db->fetch_row_assoc($sql);
			$this->session->set('token', $this->token());
			$this->session->set('logged_in', true);
			$this->session->set('admin_id', $result['admin_id']);			
			$this->session->set('user_name', $result['user_name']);
			$this->session->set('user_type', $result['user_type']);
			return true;
			
		} else {

			return false;

		}
		
	}
	
	
	 
	
	/**
	 * Remember user
	 * 
	 * @access public 
	 */	
	public function customer_login($email, $password,$remebered = false) {	
	
	 $email = filter_var($email, FILTER_SANITIZE_EMAIL);		
	 $password = filter_var($password, FILTER_SANITIZE_STRING); 		
	 $sql = "SELECT * FROM users WHERE email = '" . $email . "' AND password = '" . sha1($password) . "'"; 	
	 $sql1 = "SELECT * FROM users WHERE email = '" . $email . "' AND password = '" . $password . "'"; 	
	 if ($this->db->row_count($sql)) {						
	 session_regenerate_id(true);			
	 $this->session->set('token', $this->token());			
	 $this->session->set('logged_in', true);			
	 $result = $this->db->fetch_row_assoc($sql);			
	 $this->session->set('user_id', $result['user_id']);  			
	 $this->session->set('email', $result['email']);			
	 $this->session->set('mobile', $result['mobile']);			
	 $this->session->set('user_type', $result['user_type']);	 	
	 return true; 		
	 } else if($this->db->row_count($sql1)){
	 session_regenerate_id(true);			
	 $this->session->set('token', $this->token());			
	 $this->session->set('logged_in', true);			
	 $result = $this->db->fetch_row_assoc($sql1);			
	 $this->session->set('user_id', $result['user_id']);  			
	 $this->session->set('email', $result['email']);			
	 $this->session->set('mobile', $result['mobile']);			
	 $this->session->set('user_type', $result['user_type']);	 	
	 return true; 
	 } 
	 else { 			
	 return false; 		
	 }   	
	 }	
	 
	  	
	 
	public function remember_user($user_id, $mobile, $password) {

		//$email = filter_var($email, FILTER_SANITIZE_EMAIL);
		$password = filter_var($password, FILTER_SANITIZE_STRING);
				
		$key = $mobile . $password;

		$where = array(
			'user_id' => $user_id
		);
		
		$this->db->where($where);
		$this->db->update(self::$config['table_users'], array('remember_code' => sha1($key)));

		setcookie('remember_code', sha1($key), time() + self::$config['user_expire']);
		
	}

	/**
	 * Logged in
	 * 
	 * @access public 
	 */	
	public function logged_in() {

		if ($this->session->get('logged_in') && $this->session->get('token') == $this->token()) {
			
			return true;
		
		}
		
		return false;
		
	}
	public function admin_logged_in() {

		if ($this->session->get('is_admin') && $this->session->get('token') == $this->token()) {
			
			return true;
		
		}
		
		return false;
		
	}

	/**
	 * Auto login
	 * 
	 * @access public 
	 */	
	public function auto_login() {
	
		if (!$this->logged_in() AND !$this->logged_in(false)) {
			
			if (isset($_COOKIE['remember_code'])) {
				
				$sql = "SELECT * FROM " . self::$config['table_users'] . " u, " . self::$config['table_profiles'] . " p WHERE u.remember_code = '" . $_COOKIE['remember_code'] . "' AND p.user_id = u.user_id";
				
				if ($this->db->row_count($sql)) {

					session_regenerate_id(true);
					$this->session->set('token', $this->token());
					$this->session->set('logged_in', true);
				
					$result = $this->db->fetch_row_assoc($sql);
					$this->session->set('user_id', $result['user_id']);
					$this->session->set('group_id', $result['group_id']);
					$this->session->set('user_email', $result['user_email']);
					$this->session->set('user_status', $result['user_status']);
				/* 	$this->session->set('last_login', $result['last_login']);
					$this->session->set('last_ip', $result['last_ip']); */
					$this->session->set('contact_person_name', $result['contact_person_name']);

					$group_row = $this->db->fetch_row_assoc("SELECT group_name FROM " . self::$config['table_groups'] . " WHERE group_id = '" . $result['group_id'] . "'");
					$this->session->set('group_name', $group_row['group_name']);

				}
					
			}
			
		}
		
		return false;		
	
	}

	/**
	 * Logout
	 * 
	 * @access public 
	 */		
	public function logout() {
		
		$this->session->destroy();
		unset($_COOKIE['remember_code']);
		setcookie('remember_code', '', time() - 1);
		
	}
	
	
	/**
	 * New password
	 * 
	 * @access public 
	 */	
	public function new_password($email) {
    $email = filter_var($email, FILTER_SANITIZE_EMAIL);

    if ($this->db->row_count("SELECT user_email,user_id FROM " . self::$config['table_users'] ." WHERE user_email = '" . $email . "'")) {
        $password = substr(md5(uniqid(rand())), 0, 6);

        $where = array(
            'user_email' => $email
        );
        
        $this->db->where($where);
        $this->db->update(self::$config['table_users'], array('user_password' => $password));

        // Configure PHPMailer
        $mail = new PHPMailer;
        $mail->isSMTP();
        $mail->Host = 'mail.baba786.com';
        $mail->Port = 465; // SMTP port
        $mail->SMTPAuth = true;
        $mail->Username = 'baba786@baba786.com'; // Your email address
        $mail->Password = 'TqH@{v#TGHmA'; // Your email password
        $mail->SMTPSecure = 'ssl'; // Enable TLS encryption, `ssl` also accepted
        $mail->setFrom(self::$config['admin_email'], self::$config['site_title']);
        $mail->addAddress($email);
        $mail->isHTML(true);
        $mail->Subject = 'New Password for Baba786';
        $mail->Body = 'Your new password is: ' . $password;

        if (!$mail->send()) {
            echo 'Message could not be sent.';
            echo 'Mailer Error: ' . $mail->ErrorInfo;
            return false;
        } else {
            return true;
        }
    } else {
        return false;
    }
}


/**
	 * New password
	 * 
	 * @access public 
	 */	
	public function admin_new_password($email) {
    $email = filter_var($email, FILTER_SANITIZE_EMAIL);


    $query = "SELECT user_name, admin_id FROM admin WHERE user_name = '" . $email . "'";;
    $row_count = $this->db->row_count($query);

    if ($row_count > 0) {
        $password = substr(md5(uniqid(rand())), 0, 6);
       

        // Update password in the database
      //  $where = array(
     //       'user_name' => $email
     //   );
    //    $this->db->where($where);
        $query2 = "UPDATE admin SET admin_password = '$password' WHERE user_name = '$email'";
        $this->db->query($query2);

        // Send email with the new password
        $mail = new PHPMailer(true); // Enable verbose error output
        $mail->isSMTP();
        $mail->Host = 'mail.baba786.com';
        $mail->Port = 465; // SMTP port
        $mail->SMTPAuth = true;
        $mail->Username = 'baba786@baba786.com'; // Your email address
        $mail->Password = 'TqH@{v#TGHmA'; // Your email password
        $mail->SMTPSecure = 'ssl'; // Enable TLS encryption, `ssl` also accepted
        $mail->setFrom(self::$config['admin_email'], self::$config['site_title']);
        $mail->addAddress($email);
        $mail->isHTML(true);
        $mail->Subject = 'New Password for Baba786';
        $mail->Body = 'Your new password is: ' . $password;

        try {
            $mail->send();
            return true;
        } catch (Exception $e) {
            echo 'Message could not be sent.';
            echo 'Mailer Error: ' . $mail->ErrorInfo;
            return false;
        }
    } else {
        echo "Email does not exist in the database."; // Check if this message appears
        return false;
    }
}







	/**
	 * Is admin
	 * 
	 * @access public 
	 */	
	public function is_admin() {
		
		if ($this->session->get('group_id')) {
			
			if (self::$config['admin_group'] == $this->session->get('group_id'))
				return true;
				
		}
		
		return false;
	
	}

	/**
	 * Is group
	 * 
	 * @access public 
	 */	
	public function is_group($group) {
	
		if (is_array($group)) {
		
			return in_array($this->session->get('group_name'), $group);
			
		}

		return $this->session->get('group_name') == $group;
	
	}

	/**
	 * Check email
	 * 
	 * @access public 
	 */	
	public function check_email($email) {

		$email = filter_var($email, FILTER_SANITIZE_EMAIL);
				
		if ($this->db->row_count("SELECT user_email FROM " . self::$config['table_users'] . " WHERE user_email = '" . $email . "'")) {

			return false;
			
		} else {
			
			return true;
			
		}
		
	}
	
		public function check_mobile($mobile) { 
				
		if ($this->db->row_count("SELECT user_mobile FROM " . self::$config['table_users'] . " WHERE user_mobile = '" . $mobile . "'")) {

			return false;
			
		} else {
			
			return true;
			
		}
		
	}

	/**
	 * Add group
	 * 
	 * @access public 
	 */	
	public function add_group($name, $description) {
	
		$values = array(
				'group_name'		=> $name, 
				'group_description'	=> $description
		); 
			
		$this->db->insert(self::$config['table_groups'], $values);		
		
	}

	/**
	 * Update group
	 * 
	 * @access public 
	 */	
	public function update_group($group_id, $name, $description) {
				
		$values = array(
			'group_id'			=> $group_id,
			'group_name'		=> $name, 
			'group_description' => $description
		);
		
		$where = array(
			'group_id' => $group_id
		);
		
		$this->db->where($where);
		$this->db->update(self::$config['table_groups'], $values);
 					
	}

	/**
	 * Delete group
	 * 
	 * @access public 
	 */	
	public function delete_group($group_id) {

		$where = array(
			'group_id' => $group_id
		);
		
		$this->db->where($where);	
		$this->db->delete(self::$config['table_groups']);
	
	}
		
	/**
	 * Get group
	 * 
	 * @access public 
	 */	
	public function get_group($group_id) {
	
		foreach ($this->db->query("SELECT * FROM " . self::$config['table_groups'] . " WHERE group_id = '" . $group_id . "'") as $row) {
						
			$group = array(
				'group_id'			=> $row['group_id'],
				'group_name'		=> $row['group_name'], 
				'group_description' => $row['group_description']
			);
							
        }
		
		return $group;		
	
	}

	/**
	 * Get groups
	 * 
	 * @access public 
	 */
	 
	public function get_groups() {
	
		foreach ($this->db->query("SELECT * FROM " . self::$config['table_groups'] . "") as $row) {
						
			$groups[] = array(
				'group_id'			=> $row['group_id'], 
				'group_name'		=> $row['group_name'],
				'group_description'	=> $row['group_description']
			);
							
        }
		
		if (isset($groups))
			return $groups;
	
	}
		
}

?>
