<?php if (__FILE__ == $_SERVER['SCRIPT_FILENAME']) exit('No direct access allowed.');

/** 
 * Upload class
 */ 
class Upload {

	/**
	 * Config
	 *
	 * @access private 
	 */	
	private static $config;

	/**
	 * Error
	 *
	 * @access private 
	 */		
	private $error;
		
	/**
	 * Constructor
	 * 
	 * @access public 
	 */	  
	public function __construct() {
		
		self::$config = config_load('upload');

		$this->error = new Error();
		
	}

	/**
	 * Upload image
	 * 
	 * @access public 
	 */	 
	public function upload_image($file, $width, $height) {
		
		if (is_array($file)) {
			
			$ext = substr(strrchr($file['name'], '.'), 1);
			
			if ($file['size'] > self::$config['max_filesize'])
				$this->error->set_error('The file you attempted to upload is too large.');
				
		} else {
			
			$ext = substr(strrchr($_FILES[$file]['name'], '.'), 1);
			
			if ($_FILES[$file]['size'] > self::$config['max_filesize'])
				$this->error->set_error('The file you attempted to upload is too large.');
				
		}
		
		if (!in_array($ext, array('jpg', 'jpeg', 'png', 'gif')))
			$this->error->set_error('The file you attempted to upload is not allowed.');

		if (!is_writable(self::$config['upload_path'] . 'images/'))
			$this->error->set_error('The folder ' . self::$config['upload_path'] . ' images/ is not writeable.');

		if (!$this->error->has_errors()) {
				
			$file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext;
			
			if (is_array($file))
				copy($file['tmp_name'], self::$config['upload_path'] . 'images/' . $file_name);
			else
				copy($_FILES[$file]['tmp_name'], self::$config['upload_path'] . 'images/' . $file_name);	
			
			if (in_array($ext, array('jpg', 'jpeg', 'png', 'gif'))) {
				
				if ($ext == 'jpg' || $ext == 'jpeg' )
					$image = imagecreatefromjpeg(self::$config['upload_path'] . 'images/' . $file_name);
				elseif($ext == 'png')
					$image = imagecreatefrompng(self::$config['upload_path'] . 'images/' . $file_name);
				elseif($ext == 'gif')
					$image = imagecreatefromgif(self::$config['upload_path'] . 'images/' . $file_name);
				
				$imagesx = imagesx($image);	
				$imagesy = imagesy($image);

			/*	$new_image = imagecreatetruecolor($width, $height);
				imagecopyresampled($new_image, $image, 0, 0, 0, 0, $width, $height, $imagesx, $imagesy);*/
				 $new_image = imagecreatetruecolor($width, $height);
				imagealphablending($new_image, false);
				imagecopyresampled($new_image, $image, 0, 0, 0, 0, $width, $height, $imagesx, $imagesy);
				imagesavealpha($new_image, true); 


				if ($ext == 'jpg' || $ext == 'jpeg' )
					imagejpeg($new_image, self::$config['upload_path'] . 'images/' . $file_name, 75);
				elseif($ext == 'png')
					 imagepng($new_image, self::$config['upload_path'] . 'images/' . $file_name);
				elseif($ext == 'gif')
					imagegif($new_image, self::$config['upload_path'] . 'images/' . $file_name);

			}
				
			return $file_name;	
			
		}
	}
	
	public function upload_image_2($file, $width, $height) {
		
		if (is_array($file)) {
			
			$ext = substr(strrchr($file['name'], '.'), 1);
			
			
				 
				
		} else {
			
			$ext = substr(strrchr($_FILES[$file]['name'], '.'), 1);
			
		 
				
		}
			
			 
			
			
			$file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext;
			
			
		
				copy($_FILES[$file]['tmp_name'], '../uploads/league_of_extraorginary_entrepreneur/' . $file_name);	
			
			if (in_array($ext, array('jpg', 'jpeg', 'png', 'gif'))) {
				
				if ($ext == 'jpg' || $ext == 'jpeg' )
					$image = imagecreatefromjpeg('../uploads/league_of_extraorginary_entrepreneur/' . $file_name);
				elseif($ext == 'png')
					$image = imagecreatefrompng('../uploads/league_of_extraorginary_entrepreneur/' . $file_name);
				elseif($ext == 'gif')
					$image = imagecreatefromgif('../uploads/league_of_extraorginary_entrepreneur/' . $file_name);
				
				$imagesx = imagesx($image);	
				$imagesy = imagesy($image);

	
				$new_image = imagecreatetruecolor($width, $height);
				imagealphablending($new_image, false);
				imagecopyresampled($new_image, $image, 0, 0, 0, 0, $width, $height, $imagesx, $imagesy);
				imagesavealpha($new_image, true); 


				if ($ext == 'jpg' || $ext == 'jpeg' )
					imagejpeg($new_image, '../uploads/league_of_extraorginary_entrepreneur/' . $file_name, 75);
				elseif($ext == 'png')
					 imagepng($new_image, '../uploads/league_of_extraorginary_entrepreneur/' . $file_name);
				elseif($ext == 'gif')
					imagegif($new_image, '../uploads/league_of_extraorginary_entrepreneur/' . $file_name);

			}
				
			return $file_name;	
			
		
	}
    
     
	
	public function upload_image_featured_member($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']);
		
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'],'../uploads/featured_members/' . $file_name);
				
		return $file_name;
		
	}
    
    
    	
	public function upload_profile_pic($field_name){ 
		$ext = pathinfo($_FILES[$field_name]['name']); 
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension']; 
		copy($_FILES[$field_name]['tmp_name'],'./uploads/profile-pics/' . $file_name); 
		return $file_name; 
	}
    
	/**
	 * Upload file
	 * 
	 * @access public 
	 */	 
	public function upload_file($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']);
		
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'], self::$config['upload_path'] . 'files/' . $file_name);
				
		return $file_name;
		
	}
	
	public function upload_reels($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']);
		
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'], '../uploads/sliders/' . $file_name);
				
		return $file_name;
		
	}
	
	public function upload_paper($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']);
		
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'], '../uploads/papers/' . $file_name);
				
		return $file_name;
		
	}
	public function upload_paper_2($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']);
		
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'], '../uploads/images/' . $file_name);
				
		return $file_name;
		
	}
	public function upload_paper_3($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']);
		
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'], '../uploads/images/' . $file_name);
				
		return $file_name;
		
	}
	public function upload_paper_4($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']);
		
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'], '../uploads/images/' . $file_name);
				
		return $file_name;
		
	}
	
	
	
	public function upload_file_media($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']); 
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'], '../uploads/news_media/' . $file_name);
				
		return $file_name;
		
	}
	
	
	public function board_members_mentors_experts_eed($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']); 
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'], '../uploads/advisory_board_members/' . $file_name);
				
		return $file_name;
		
	}
	
	
	public function upload_event_banner($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']);
		
	   
        $file_name =  time() . md5(uniqid(mt_rand())) . '.' . $ext['extension'];
     
		copy($_FILES[$field_name]['tmp_name'], '../uploads/event_banner/' . $file_name);
				
		return $file_name;
		
	}
	
	
	/**
	 * Upload file
	 * 
	 * @access public 
	 */	 
	public function upload_image_direct($field_name) {
		
		$ext = pathinfo($_FILES[$field_name]['name']);
		
		$name = time(). '.' . $ext['extension'];
		/* 
		var_dump($ext['extension']);
		var_dump(self::$config['upload_path'].'images/'.$name);
		exit;
		*/
		copy($_FILES[$field_name]['tmp_name'], '../uploads/images/'.$name);
		//move_uploaded_file($_FILES['profile_img']['tmp_name'], self::$config['upload_path'] . 'images/'.$name);
		return $name;	
			
			
	}
		
}

?>
