/*
 Platform.js <https://mths.be/platform>
 Copyright 2014-2018 Benjamin Tan <https://bnjmnt4n.now.sh/>
 Copyright 2011-2013 John-David Dalton
 Available under MIT license <https://mths.be/mit>
*/
(function() {
    var a = "undefined" !== typeof window && "undefined" !== typeof window.document ? window.document : {},
        c = "undefined" !== typeof module && module.exports,
        b = "undefined" !== typeof Element && "ALLOW_KEYBOARD_INPUT" in Element,
        d = function() {
            for (var b, c = ["requestFullscreen exitFullscreen fullscreenElement fullscreenEnabled fullscreenchange fullscreenerror".split(" "), "webkitRequestFullscreen webkitExitFullscreen webkitFullscreenElement webkitFullscreenEnabled webkitfullscreenchange webkitfullscreenerror".split(" "),
                    "webkitRequestFullScreen webkitCancelFullScreen webkitCurrentFullScreenElement webkitCancelFullScreen webkitfullscreenchange webkitfullscreenerror".split(" "), "mozRequestFullScreen mozCancelFullScreen mozFullScreenElement mozFullScreenEnabled mozfullscreenchange mozfullscreenerror".split(" "), "msRequestFullscreen msExitFullscreen msFullscreenElement msFullscreenEnabled MSFullscreenChange MSFullscreenError".split(" ")
                ], d = 0, g = c.length, h = {}; d < g; d++)
                if ((b = c[d]) && b[1] in a) {
                    for (d = 0; d < b.length; d++) h[c[0][d]] =
                        b[d];
                    return h
                } return !1
        }(),
        g = {
            change: d.fullscreenchange,
            error: d.fullscreenerror
        },
        h = {
            request: function(c) {
                var f = d.requestFullscreen;
                c = c || a.documentElement;
                if (/5\.1[.\d]* Safari/.test(navigator.userAgent)) c[f]();
                else c[f](b && Element.ALLOW_KEYBOARD_INPUT)
            },
            exit: function() {
                a[d.exitFullscreen]()
            },
            toggle: function(a) {
                this.isFullscreen ? this.exit() : this.request(a)
            },
            onchange: function(a) {
                this.on("change", a)
            },
            onerror: function(a) {
                this.on("error", a)
            },
            on: function(b, c) {
                var d = g[b];
                d && a.addEventListener(d, c, !1)
            },
            off: function(b,
                c) {
                var d = g[b];
                d && a.removeEventListener(d, c, !1)
            },
            raw: d
        };
    d ? (Object.defineProperties(h, {
        isFullscreen: {
            get: function() {
                return !!a[d.fullscreenElement]
            }
        },
        element: {
            enumerable: !0,
            get: function() {
                return a[d.fullscreenElement]
            }
        },
        enabled: {
            enumerable: !0,
            get: function() {
                return !!a[d.fullscreenEnabled]
            }
        }
    }), c ? module.exports = h : window.screenfull = h) : c ? module.exports = !1 : window.screenfull = !1
})();
(function() {
    function a(a) {
        a = String(a);
        return a.charAt(0).toUpperCase() + a.slice(1)
    }

    function c(a, b) {
        var c = -1,
            f = a ? a.length : 0;
        if ("number" == typeof f && -1 < f && f <= v)
            for (; ++c < f;) b(a[c], c, a);
        else d(a, b)
    }

    function b(b) {
        b = String(b).replace(/^ +| +$/g, "");
        return /^(?:webOS|i(?:OS|P))/.test(b) ? b : a(b)
    }

    function d(a, b) {
        for (var c in a) B.call(a, c) && b(a[c], c, a)
    }

    function g(b) {
        return null == b ? a(b) : t.call(b).slice(8, -1)
    }

    function h(a, b) {
        var c = null != a ? typeof a[b] : "number";
        return !/^(?:boolean|number|string|undefined)$/.test(c) &&
            ("object" == c ? !!a[b] : !0)
    }

    function f(a) {
        return String(a).replace(/([ -])(?!$)/g, "$1?")
    }

    function p(a, b) {
        var d = null;
        c(a, function(c, f) {
            d = b(d, c, f, a)
        });
        return d
    }

    function m(a) {
        function c(c) {
            return p(c, function(c, d) {
                var e = d.pattern || f(d);
                !c && (c = RegExp("\\b" + e + " *\\d+[.\\w_]*", "i").exec(a) || RegExp("\\b" + e + " *\\w+-[\\w]*", "i").exec(a) || RegExp("\\b" + e + "(?:; *(?:[a-z]+[_-])?[a-z]+\\d+|[^ ();-]*)", "i").exec(a)) && ((c = String(d.label && !RegExp(e, "i").test(d.label) ? d.label : c).split("/"))[1] && !/[\d.]+/.test(c[0]) && (c[0] +=
                    " " + c[1]), d = d.label || d, c = b(c[0].replace(RegExp(e, "i"), d).replace(RegExp("; *(?:" + d + "[_-])?", "i"), " ").replace(RegExp("(" + d + ")[-_.]?(\\w)", "i"), "$1 $2")));
                return c
            })
        }

        function y(b) {
            return p(b, function(b, c) {
                return b || (RegExp(c + "(?:-[\\d.]+/|(?: for [\\w-]+)?[ /-])([\\d.]+[^ ();/_-]*)", "i").exec(a) || 0)[1] || null
            })
        }
        var k = x,
            l = a && "object" == typeof a && "String" != g(a);
        l && (k = a, a = null);
        var r = k.navigator || {},
            u = r.userAgent || "";
        a || (a = u);
        var v = l ? !!r.likeChrome : /\bChrome\b/.test(a) && !/internal|\n/i.test(t.toString()),
            D = l ? "Object" : "ScriptBridgingProxyObject",
            B = l ? "Object" : "Environment",
            H = l && k.java ? "JavaPackage" : g(k.java),
            O = l ? "Object" : "RuntimeObject";
        B = (H = /\bJava/.test(H) && k.java) && g(k.environment) == B;
        var P = H ? "a" : "\u03b1",
            Q = H ? "b" : "\u03b2",
            L = k.document || {},
            E = k.operamini || k.opera,
            I = w.test(I = l && E ? E["[[Class]]"] : g(E)) ? I : E = null,
            e, J = a;
        l = [];
        var K = null,
            F = a == u;
        u = F && E && "function" == typeof E.version && E.version();
        var z = function(b) {
                return p(b, function(b, c) {
                    return b || RegExp("\\b" + (c.pattern || f(c)) + "\\b", "i").exec(a) && (c.label ||
                        c)
                })
            }([{
                label: "EdgeHTML",
                pattern: "Edge"
            }, "Trident", {
                label: "WebKit",
                pattern: "AppleWebKit"
            }, "iCab", "Presto", "NetFront", "Tasman", "KHTML", "Gecko"]),
            n = function(b) {
                return p(b, function(b, c) {
                    return b || RegExp("\\b" + (c.pattern || f(c)) + "\\b", "i").exec(a) && (c.label || c)
                })
            }(["Adobe AIR", "Arora", "Avant Browser", "Breach", "Camino", "Electron", "Epiphany", "Fennec", "Flock", "Galeon", "GreenBrowser", "iCab", "Iceweasel", "K-Meleon", "Konqueror", "Lunascape", "Maxthon", {
                    label: "Microsoft Edge",
                    pattern: "Edge"
                }, "Midori", "Nook Browser",
                "PaleMoon", "PhantomJS", "Raven", "Rekonq", "RockMelt", {
                    label: "Samsung Internet",
                    pattern: "SamsungBrowser"
                }, "SeaMonkey", {
                    label: "Silk",
                    pattern: "(?:Cloud9|Silk-Accelerated)"
                }, "Sleipnir", "SlimBrowser", {
                    label: "SRWare Iron",
                    pattern: "Iron"
                }, "Sunrise", "Swiftfox", "Waterfox", "WebPositive", "Opera Mini", {
                    label: "Opera Mini",
                    pattern: "OPiOS"
                }, "Opera", {
                    label: "Opera",
                    pattern: "OPR"
                }, "Chrome", {
                    label: "Chrome Mobile",
                    pattern: "(?:CriOS|CrMo)"
                }, {
                    label: "Firefox",
                    pattern: "(?:Firefox|Minefield)"
                }, {
                    label: "Firefox for iOS",
                    pattern: "FxiOS"
                },
                {
                    label: "IE",
                    pattern: "IEMobile"
                }, {
                    label: "IE",
                    pattern: "MSIE"
                }, "Safari"
            ]),
            A = c([{
                    label: "BlackBerry",
                    pattern: "BB10"
                }, "BlackBerry", {
                    label: "Galaxy S",
                    pattern: "GT-I9000"
                }, {
                    label: "Galaxy S2",
                    pattern: "GT-I9100"
                }, {
                    label: "Galaxy S3",
                    pattern: "GT-I9300"
                }, {
                    label: "Galaxy S4",
                    pattern: "GT-I9500"
                }, {
                    label: "Galaxy S5",
                    pattern: "SM-G900"
                }, {
                    label: "Galaxy S6",
                    pattern: "SM-G920"
                }, {
                    label: "Galaxy S6 Edge",
                    pattern: "SM-G925"
                }, {
                    label: "Galaxy S7",
                    pattern: "SM-G930"
                }, {
                    label: "Galaxy S7 Edge",
                    pattern: "SM-G935"
                }, "Google TV", "Lumia", "iPad",
                "iPod", "iPhone", "Kindle", {
                    label: "Kindle Fire",
                    pattern: "(?:Cloud9|Silk-Accelerated)"
                }, "Nexus", "Nook", "PlayBook", "PlayStation Vita", "PlayStation", "TouchPad", "Transformer", {
                    label: "Wii U",
                    pattern: "WiiU"
                }, "Wii", "Xbox One", {
                    label: "Xbox 360",
                    pattern: "Xbox"
                }, "Xoom"
            ]),
            C = function(b) {
                return p(b, function(b, c, d) {
                    return b || (c[A] || c[/^[a-z]+(?: +[a-z]+\b)*/i.exec(A)] || RegExp("\\b" + f(d) + "(?:\\b|\\w*\\d)", "i").exec(a)) && d
                })
            }({
                Apple: {
                    iPad: 1,
                    iPhone: 1,
                    iPod: 1
                },
                Archos: {},
                Amazon: {
                    Kindle: 1,
                    "Kindle Fire": 1
                },
                Asus: {
                    Transformer: 1
                },
                "Barnes & Noble": {
                    Nook: 1
                },
                BlackBerry: {
                    PlayBook: 1
                },
                Google: {
                    "Google TV": 1,
                    Nexus: 1
                },
                HP: {
                    TouchPad: 1
                },
                HTC: {},
                LG: {},
                Microsoft: {
                    Xbox: 1,
                    "Xbox One": 1
                },
                Motorola: {
                    Xoom: 1
                },
                Nintendo: {
                    "Wii U": 1,
                    Wii: 1
                },
                Nokia: {
                    Lumia: 1
                },
                Samsung: {
                    "Galaxy S": 1,
                    "Galaxy S2": 1,
                    "Galaxy S3": 1,
                    "Galaxy S4": 1
                },
                Sony: {
                    PlayStation: 1,
                    "PlayStation Vita": 1
                }
            }),
            q = function(c) {
                return p(c, function(c, d) {
                    var e = d.pattern || f(d);
                    if (!c && (c = RegExp("\\b" + e + "(?:/[\\d.]+|[ \\w.]*)", "i").exec(a))) {
                        var k = c,
                            g = d.label || d,
                            l = {
                                "10.0": "10",
                                "6.4": "10 Technical Preview",
                                "6.3": "8.1",
                                "6.2": "8",
                                "6.1": "Server 2008 R2 / 7",
                                "6.0": "Server 2008 / Vista",
                                "5.2": "Server 2003 / XP 64-bit",
                                "5.1": "XP",
                                "5.01": "2000 SP1",
                                "5.0": "2000",
                                "4.0": "NT",
                                "4.90": "ME"
                            };
                        e && g && /^Win/i.test(k) && !/^Windows Phone /i.test(k) && (l = l[/[\d.]+$/.exec(k)]) && (k = "Windows " + l);
                        k = String(k);
                        e && g && (k = k.replace(RegExp(e, "i"), g));
                        c = k = b(k.replace(/ ce$/i, " CE").replace(/\bhpw/i, "web").replace(/\bMacintosh\b/, "Mac OS").replace(/_PowerPC\b/i, " OS").replace(/\b(OS X) [^ \d]+/i, "$1").replace(/\bMac (OS X)\b/, "$1").replace(/\/(\d)/,
                            " $1").replace(/_/g, ".").replace(/(?: BePC|[ .]*fc[ \d.]+)$/i, "").replace(/\bx86\.64\b/gi, "x86_64").replace(/\b(Windows Phone) OS\b/, "$1").replace(/\b(Chrome OS \w+) [\d.]+\b/, "$1").split(" on ")[0])
                    }
                    return c
                })
            }(["Windows Phone", "Android", "CentOS", {
                    label: "Chrome OS",
                    pattern: "CrOS"
                }, "Debian", "Fedora", "FreeBSD", "Gentoo", "Haiku", "Kubuntu", "Linux Mint", "OpenBSD", "Red Hat", "SuSE", "Ubuntu", "Xubuntu", "Cygwin", "Symbian OS", "hpwOS", "webOS ", "webOS", "Tablet OS", "Tizen", "Linux", "Mac OS X", "Macintosh", "Mac",
                "Windows 98;", "Windows "
            ]);
        z && (z = [z]);
        C && !A && (A = c([C]));
        if (e = /\bGoogle TV\b/.exec(A)) A = e[0];
        /\bSimulator\b/i.test(a) && (A = (A ? A + " " : "") + "Simulator");
        "Opera Mini" == n && /\bOPiOS\b/.test(a) && l.push("running in Turbo/Uncompressed mode");
        "IE" == n && /\blike iPhone OS\b/.test(a) ? (e = m(a.replace(/like iPhone OS/, "")), C = e.manufacturer, A = e.product) : /^iP/.test(A) ? (n || (n = "Safari"), q = "iOS" + ((e = / OS ([\d_]+)/i.exec(a)) ? " " + e[1].replace(/_/g, ".") : "")) : "Konqueror" != n || /buntu/i.test(q) ? C && "Google" != C && (/Chrome/.test(n) &&
            !/\bMobile Safari\b/i.test(a) || /\bVita\b/.test(A)) || /\bAndroid\b/.test(q) && /^Chrome/.test(n) && /\bVersion\//i.test(a) ? (n = "Android Browser", q = /\bAndroid\b/.test(q) ? q : "Android") : "Silk" == n ? (/\bMobi/i.test(a) || (q = "Android", l.unshift("desktop mode")), /Accelerated *= *true/i.test(a) && l.unshift("accelerated")) : "PaleMoon" == n && (e = /\bFirefox\/([\d.]+)\b/.exec(a)) ? l.push("identifying as Firefox " + e[1]) : "Firefox" == n && (e = /\b(Mobile|Tablet|TV)\b/i.exec(a)) ? (q || (q = "Firefox OS"), A || (A = e[1])) : !n || (e = !/\bMinefield\b/i.test(a) &&
            /\b(?:Firefox|Safari)\b/.exec(n)) ? (n && !A && /[\/,]|^[^(]+?\)/.test(a.slice(a.indexOf(e + "/") + 8)) && (n = null), (e = A || C || q) && (A || C || /\b(?:Android|Symbian OS|Tablet OS|webOS)\b/.test(q)) && (n = /[a-z]+(?: Hat)?/i.exec(/\bAndroid\b/.test(q) ? q : e) + " Browser")) : "Electron" == n && (e = (/\bChrome\/([\d.]+)\b/.exec(a) || 0)[1]) && l.push("Chromium " + e) : q = "Kubuntu";
        u || (u = y(["(?:Cloud9|CriOS|CrMo|Edge|FxiOS|IEMobile|Iron|Opera ?Mini|OPiOS|OPR|Raven|SamsungBrowser|Silk(?!/[\\d.]+$))", "Version", f(n), "(?:Firefox|Minefield|NetFront)"]));
        if (e = "iCab" == z && 3 < parseFloat(u) && "WebKit" || /\bOpera\b/.test(n) && (/\bOPR\b/.test(a) ? "Blink" : "Presto") || /\b(?:Midori|Nook|Safari)\b/i.test(a) && !/^(?:Trident|EdgeHTML)$/.test(z) && "WebKit" || !z && /\bMSIE\b/i.test(a) && ("Mac OS" == q ? "Tasman" : "Trident") || "WebKit" == z && /\bPlayStation\b(?! Vita\b)/i.test(n) && "NetFront") z = [e];
        "IE" == n && (e = (/; *(?:XBLWP|ZuneWP)(\d+)/i.exec(a) || 0)[1]) ? (n += " Mobile", q = "Windows Phone " + (/\+$/.test(e) ? e : e + ".x"), l.unshift("desktop mode")) : /\bWPDesktop\b/i.test(a) ? (n = "IE Mobile", q = "Windows Phone 8.x",
            l.unshift("desktop mode"), u || (u = (/\brv:([\d.]+)/.exec(a) || 0)[1])) : "IE" != n && "Trident" == z && (e = /\brv:([\d.]+)/.exec(a)) && (n && l.push("identifying as " + n + (u ? " " + u : "")), n = "IE", u = e[1]);
        if (F) {
            if (h(k, "global"))
                if (H && (e = H.lang.System, J = e.getProperty("os.arch"), q = q || e.getProperty("os.name") + " " + e.getProperty("os.version")), B) {
                    try {
                        u = k.require("ringo/engine").version.join("."), n = "RingoJS"
                    } catch (N) {
                        (e = k.system) && e.global.system == k.system && (n = "Narwhal", q || (q = e[0].os || null))
                    }
                    n || (n = "Rhino")
                } else "object" == typeof k.process &&
                    !k.process.browser && (e = k.process) && ("object" == typeof e.versions && ("string" == typeof e.versions.electron ? (l.push("Node " + e.versions.node), n = "Electron", u = e.versions.electron) : "string" == typeof e.versions.nw && (l.push("Chromium " + u, "Node " + e.versions.node), n = "NW.js", u = e.versions.nw)), n || (n = "Node.js", J = e.arch, q = e.platform, u = (u = /[\d.]+/.exec(e.version)) ? u[0] : null));
            else g(e = k.runtime) == D ? (n = "Adobe AIR", q = e.flash.system.Capabilities.os) : g(e = k.phantom) == O ? (n = "PhantomJS", u = (e = e.version || null) && e.major + "." + e.minor +
                "." + e.patch) : "number" == typeof L.documentMode && (e = /\bTrident\/(\d+)/i.exec(a)) ? (u = [u, L.documentMode], (e = +e[1] + 4) != u[1] && (l.push("IE " + u[1] + " mode"), z && (z[1] = ""), u[1] = e), u = "IE" == n ? String(u[1].toFixed(1)) : u[0]) : "number" == typeof L.documentMode && /^(?:Chrome|Firefox)\b/.test(n) && (l.push("masking as " + n + " " + u), n = "IE", u = "11.0", z = ["Trident"], q = "Windows");
            q = q && b(q)
        }
        u && (e = /(?:[ab]|dp|pre|[ab]\d+pre)(?:\d+\+?)?$/i.exec(u) || /(?:alpha|beta)(?: ?\d)?/i.exec(a + ";" + (F && r.appMinorVersion)) || /\bMinefield\b/i.test(a) &&
            "a") && (K = /b/i.test(e) ? "beta" : "alpha", u = u.replace(RegExp(e + "\\+?$"), "") + ("beta" == K ? Q : P) + (/\d+\+?/.exec(e) || ""));
        if ("Fennec" == n || "Firefox" == n && /\b(?:Android|Firefox OS)\b/.test(q)) n = "Firefox Mobile";
        else if ("Maxthon" == n && u) u = u.replace(/\.[\d.]+/, ".x");
        else if (/\bXbox\b/i.test(A)) "Xbox 360" == A && (q = null), "Xbox 360" == A && /\bIEMobile\b/.test(a) && l.unshift("mobile mode");
        else if (!/^(?:Chrome|IE|Opera)$/.test(n) && (!n || A || /Browser|Mobi/.test(n)) || "Windows CE" != q && !/Mobi/i.test(a))
            if ("IE" == n && F) try {
                null === k.external &&
                    l.unshift("platform preview")
            } catch (N) {
                l.unshift("embedded")
            } else(/\bBlackBerry\b/.test(A) || /\bBB10\b/.test(a)) && (e = (RegExp(A.replace(/ +/g, " *") + "/([.\\d]+)", "i").exec(a) || 0)[1] || u) ? (e = [e, /BB10/.test(a)], q = (e[1] ? (A = null, C = "BlackBerry") : "Device Software") + " " + e[0], u = null) : this != d && "Wii" != A && (F && E || /Opera/.test(n) && /\b(?:MSIE|Firefox)\b/i.test(a) || "Firefox" == n && /\bOS X (?:\d+\.){2,}/.test(q) || "IE" == n && (q && !/^Win/.test(q) && 5.5 < u || /\bWindows XP\b/.test(q) && 8 < u || 8 == u && !/\bTrident\b/.test(a))) && !w.test(e =
                m.call(d, a.replace(w, "") + ";")) && e.name && (e = "ing as " + e.name + ((e = e.version) ? " " + e : ""), w.test(n) ? (/\bIE\b/.test(e) && "Mac OS" == q && (q = null), e = "identify" + e) : (e = "mask" + e, n = I ? b(I.replace(/([a-z])([A-Z])/g, "$1 $2")) : "Opera", /\bIE\b/.test(e) && (q = null), F || (u = null)), z = ["Presto"], l.push(e));
            else n += " Mobile";
        if (e = (/\bAppleWebKit\/([\d.]+\+?)/i.exec(a) || 0)[1]) {
            e = [parseFloat(e.replace(/\.(\d)$/, ".0$1")), e];
            if ("Safari" == n && "+" == e[1].slice(-1)) n = "WebKit Nightly", K = "alpha", u = e[1].slice(0, -1);
            else if (u == e[1] || u == (e[2] =
                    (/\bSafari\/([\d.]+\+?)/i.exec(a) || 0)[1])) u = null;
            e[1] = (/\bChrome\/([\d.]+)/i.exec(a) || 0)[1];
            537.36 == e[0] && 537.36 == e[2] && 28 <= parseFloat(e[1]) && "WebKit" == z && (z = ["Blink"]);
            F && (v || e[1]) ? (z && (z[1] = "like Chrome"), e = e[1] || (e = e[0], 530 > e ? 1 : 532 > e ? 2 : 532.05 > e ? 3 : 533 > e ? 4 : 534.03 > e ? 5 : 534.07 > e ? 6 : 534.1 > e ? 7 : 534.13 > e ? 8 : 534.16 > e ? 9 : 534.24 > e ? 10 : 534.3 > e ? 11 : 535.01 > e ? 12 : 535.02 > e ? "13+" : 535.07 > e ? 15 : 535.11 > e ? 16 : 535.19 > e ? 17 : 536.05 > e ? 18 : 536.1 > e ? 19 : 537.01 > e ? 20 : 537.11 > e ? "21+" : 537.13 > e ? 23 : 537.18 > e ? 24 : 537.24 > e ? 25 : 537.36 > e ? 26 : "Blink" !=
                z ? "27" : "28")) : (z && (z[1] = "like Safari"), e = (e = e[0], 400 > e ? 1 : 500 > e ? 2 : 526 > e ? 3 : 533 > e ? 4 : 534 > e ? "4+" : 535 > e ? 5 : 537 > e ? 6 : 538 > e ? 7 : 601 > e ? 8 : "8"));
            z && (z[1] += " " + (e += "number" == typeof e ? ".x" : /[.+]/.test(e) ? "" : "+"));
            "Safari" == n && (!u || 45 < parseInt(u)) && (u = e)
        }
        "Opera" == n && (e = /\bzbov|zvav$/.exec(q)) ? (n += " ", l.unshift("desktop mode"), "zvav" == e ? (n += "Mini", u = null) : n += "Mobile", q = q.replace(RegExp(" *" + e + "$"), "")) : "Safari" == n && /\bChrome\b/.exec(z && z[1]) && (l.unshift("desktop mode"), n = "Chrome Mobile", u = null, /\bOS X\b/.test(q) ? (C =
            "Apple", q = "iOS 4.3+") : q = null);
        u && 0 == u.indexOf(e = /[\d.]+$/.exec(q)) && -1 < a.indexOf("/" + e + "-") && (q = String(q.replace(e, "")).replace(/^ +| +$/g, ""));
        z && !/\b(?:Avant|Nook)\b/.test(n) && (/Browser|Lunascape|Maxthon/.test(n) || "Safari" != n && /^iOS/.test(q) && /\bSafari\b/.test(z[1]) || /^(?:Adobe|Arora|Breach|Midori|Opera|Phantom|Rekonq|Rock|Samsung Internet|Sleipnir|Web)/.test(n) && z[1]) && (e = z[z.length - 1]) && l.push(e);
        l.length && (l = ["(" + l.join("; ") + ")"]);
        C && A && 0 > A.indexOf(C) && l.push("on " + C);
        A && l.push((/^on /.test(l[l.length -
            1]) ? "" : "on ") + A);
        if (q) {
            var M = (e = / ([\d.+]+)$/.exec(q)) && "/" == q.charAt(q.length - e[0].length - 1);
            q = {
                architecture: 32,
                family: e && !M ? q.replace(e[0], "") : q,
                version: e ? e[1] : null,
                toString: function() {
                    var a = this.version;
                    return this.family + (a && !M ? " " + a : "") + (64 == this.architecture ? " 64-bit" : "")
                }
            }
        }(e = /\b(?:AMD|IA|Win|WOW|x86_|x)64\b/i.exec(J)) && !/\bi686\b/i.test(J) ? (q && (q.architecture = 64, q.family = q.family.replace(RegExp(" *" + e), "")), n && (/\bWOW64\b/i.test(a) || F && /\w(?:86|32)$/.test(r.cpuClass || r.platform) && !/\bWin64; x64\b/i.test(a)) &&
            l.unshift("32-bit")) : q && /^OS X/.test(q.family) && "Chrome" == n && 39 <= parseFloat(u) && (q.architecture = 64);
        a || (a = null);
        k = {};
        k.description = a;
        k.layout = z && z[0];
        k.manufacturer = C;
        k.name = n;
        k.prerelease = K;
        k.product = A;
        k.ua = a;
        k.version = n && u;
        k.os = q || {
            architecture: null,
            family: null,
            version: null,
            toString: function() {
                return "null"
            }
        };
        k.parse = m;
        k.toString = function() {
            return this.description || ""
        };
        k.version && l.unshift(u);
        k.name && l.unshift(n);
        q && n && (q != String(q).split(" ")[0] || q != n.split(" ")[0] && !A) && l.push(A ? "(" + q + ")" : "on " +
            q);
        l.length && (k.description = l.join(" "));
        return k
    }
    var k = {
            "function": !0,
            object: !0
        },
        x = k[typeof window] && window || this,
        l = k[typeof exports] && exports;
    k = k[typeof module] && module && !module.nodeType && module;
    var r = l && k && "object" == typeof global && global;
    !r || r.global !== r && r.window !== r && r.self !== r || (x = r);
    var v = Math.pow(2, 53) - 1,
        w = /\bOpera/;
    r = Object.prototype;
    var B = r.hasOwnProperty,
        t = r.toString,
        y = m();
    "function" == typeof define && "object" == typeof define.amd && define.amd ? (x.platform = y, define(function() {
            return y
        })) : l &&
        k ? d(y, function(a, b) {
            l[b] = a
        }) : x.platform = y
}).call(this);

function buildIOSMeta() {
    for (var a = [{
            name: "viewport",
            content: "width=device-width, height=device-height, initial-scale=1, minimum-scale=1, maximum-scale=1, user-scalable=no"
        }, {
            name: "apple-mobile-web-app-capable",
            content: "yes"
        }, {
            name: "apple-mobile-web-app-status-bar-style",
            content: "black"
        }], c = 0; c < a.length; c++) {
        var b = document.createElement("meta");
        b.name = a[c].name;
        b.content = a[c].content;
        var d = window.document.head.querySelector('meta[name="' + b.name + '"]');
        d && d.parentNode.removeChild(d);
        window.document.head.appendChild(b)
    }
}

function hideIOSFullscreenPanel() {
    jQuery(".xxx-ios-fullscreen-message").css("display", "none");
    jQuery(".xxx-ios-fullscreen-scroll").css("display", "none");
    jQuery(".xxx-game-iframe-full").removeClass("xxx-game-iframe-iphone-se")
}

function buildIOSFullscreenPanel() {
    jQuery("body").append('<div class="xxx-ios-fullscreen-message"><div class="xxx-ios-fullscreen-swipe"></div></div><div class="xxx-ios-fullscreen-scroll"></div>')
}

function showIOSFullscreenPanel() {
    jQuery(".xxx-ios-fullscreen-message").css("display", "block");
    jQuery(".xxx-ios-fullscreen-scroll").css("display", "block")
}

function __iosResize() {
    window.scrollTo(0, 0);
    if ("iPhone" === platform.product) switch (window.devicePixelRatio) {
        case 2:
            switch (window.innerWidth) {
                case 568:
                    320 !== window.innerHeight && jQuery(".xxx-game-iframe-full").addClass("xxx-game-iframe-iphone-se");
                    break;
                case 667:
                    375 === window.innerHeight ? hideIOSFullscreenPanel() : showIOSFullscreenPanel();
                    break;
                default:
                    hideIOSFullscreenPanel()
            }
            break;
        case 3:
            switch (window.innerWidth) {
                case 736:
                    414 === window.innerHeight ? hideIOSFullscreenPanel() : showIOSFullscreenPanel();
                    break;
                case 724:
                    375 === window.innerHeight ? hideIOSFullscreenPanel() : showIOSFullscreenPanel();
                    break;
                default:
                    hideIOSFullscreenPanel()
            }
            break;
        default:
            hideIOSFullscreenPanel()
    }
}

function iosResize() {
    __iosResize();
    setTimeout(function() {
        __iosResize()
    }, 500)
}
$(document).ready(function() {
    platform && "iPhone" === platform.product && "Safari" === platform.name && (buildIOSFullscreenPanel(), buildIOSMeta())
});
jQuery(window).resize(function() {
    platform && "iPhone" === platform.product && "Safari" === platform.name && iosResize()
});
var s_iScaleFactor = 1,
    s_bIsIphone = !1,
    s_iOffsetX, s_iOffsetY, s_oCanvasLeft, s_oCanvasTop;
(function(a) {
    (jQuery.browser = jQuery.browser || {}).mobile = /android|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(ad|hone|od)|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|symbian|tablet|treo|up\.(browser|link)|vodafone|wap|webos|windows (ce|phone)|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|e\-|e\/|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(di|rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|xda(\-|2|g)|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))
})(navigator.userAgent ||
    navigator.vendor || window.opera);
$(window).resize(function() {
    sizeHandler()
});

function trace(a) {
    console.log(a)
}

function getSize(a) {
    var c = a.toLowerCase(),
        b = window.document,
        d = b.documentElement;
    if (void 0 === window["inner" + a]) a = d["client" + a];
    else if (window["inner" + a] != d["client" + a]) {
        var g = b.createElement("body");
        g.id = "vpw-test-b";
        g.style.cssText = "overflow:scroll";
        var h = b.createElement("div");
        h.id = "vpw-test-d";
        h.style.cssText = "position:absolute;top:-1000px";
        h.innerHTML = "<style>@media(" + c + ":" + d["client" + a] + "px){body#vpw-test-b div#vpw-test-d{" + c + ":7px!important}}</style>";
        g.appendChild(h);
        d.insertBefore(g, b.head);
        a = 7 == h["offset" + a] ? d["client" + a] : window["inner" + a];
        d.removeChild(g)
    } else a = window["inner" + a];
    return a
}
window.addEventListener("orientationchange", onOrientationChange);

function onOrientationChange() {
    window.matchMedia("(orientation: portrait)").matches && sizeHandler();
    window.matchMedia("(orientation: landscape)").matches && sizeHandler()
}

function isChrome() {
    return /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor)
}

function isIOS() {
    var a = "iPad Simulator;iPhone Simulator;iPod Simulator;iPad;iPhone;iPod".split(";");
    for (-1 !== navigator.userAgent.toLowerCase().indexOf("iphone") && (s_bIsIphone = !0); a.length;)
        if (navigator.platform === a.pop()) return !0;
    return s_bIsIphone = !1
}

function getIOSWindowHeight() {
    return document.documentElement.clientWidth / window.innerWidth * window.innerHeight
}

function getHeightOfIOSToolbars() {
    var a = (0 === window.orientation ? screen.height : screen.width) - getIOSWindowHeight();
    return 1 < a ? a : 0
}

function sizeHandler() {
    window.scrollTo(0, 1);
    if ($("#canvas")) {
        var a = "safari" === platform.name.toLowerCase() ? getIOSWindowHeight() : getSize("Height");
        var c = getSize("Width");
        _checkOrientation(c, a);
        var b = Math.min(a / CANVAS_HEIGHT, c / CANVAS_WIDTH),
            d = CANVAS_WIDTH * b;
        b *= CANVAS_HEIGHT;
        if (b < a) {
            var g = a - b;
            b += g;
            d += CANVAS_WIDTH / CANVAS_HEIGHT * g
        } else d < c && (g = c - d, d += g, b += CANVAS_HEIGHT / CANVAS_WIDTH * g);
        g = a / 2 - b / 2;
        var h = c / 2 - d / 2,
            f = CANVAS_WIDTH / d;
        if (h * f < -EDGEBOARD_X || g * f < -EDGEBOARD_Y) b = Math.min(a / (CANVAS_HEIGHT - 2 * EDGEBOARD_Y),
            c / (CANVAS_WIDTH - 2 * EDGEBOARD_X)), d = CANVAS_WIDTH * b, b *= CANVAS_HEIGHT, g = (a - b) / 2, h = (c - d) / 2, f = CANVAS_WIDTH / d;
        s_iOffsetX = -1 * h * f;
        s_iOffsetY = -1 * g * f;
        0 <= g && (s_iOffsetY = 0);
        0 <= h && (s_iOffsetX = 0);
        null !== s_oInterface && s_oInterface.refreshButtonPos(s_iOffsetX, s_iOffsetY);
        null !== s_oMenu && s_oMenu.refreshButtonPos(s_iOffsetX, s_iOffsetY);
        s_bIsIphone ? (canvas = document.getElementById("canvas"), s_oStage.canvas.width = 2 * d, s_oStage.canvas.height = 2 * b, canvas.style.width = d + "px", canvas.style.height = b + "px", s_iScaleFactor = 2 * Math.min(d /
            CANVAS_WIDTH, b / CANVAS_HEIGHT), s_oStage.scaleX = s_oStage.scaleY = s_iScaleFactor) : s_bMobile || isChrome() ? ($("#canvas").css("width", d + "px"), $("#canvas").css("height", b + "px"), s_iScaleFactor = 1) : (s_oStage.canvas.width = d, s_oStage.canvas.height = b, s_iScaleFactor = Math.min(d / CANVAS_WIDTH, b / CANVAS_HEIGHT), s_oStage.scaleX = s_oStage.scaleY = s_iScaleFactor);
        0 > g || (g = (a - b) / 2);
        $("#canvas").css("top", g + "px");
        $("#canvas").css("left", h + "px");
        d = CANVAS_WIDTH;
        b = CANVAS_HEIGHT;
        c = window.innerWidth;
        a = window.innerHeight;
        s_iScaleFactor =
            Math.min(a / b, c / d);
        s_oCanvasLeft = $("#canvas").offset().left;
        s_oCanvasTop = $("#canvas").offset().top;
        fullscreenHandler()
    }
}

function _checkOrientation(a, c) {
    s_bMobile && ENABLE_CHECK_ORIENTATION && (a > c ? "landscape" === $(".orientation-msg-container").attr("data-orientation") ? ($(".orientation-msg-container").css("display", "none"), s_oMain.startUpdate()) : ($(".orientation-msg-container").css("display", "block"), s_oMain.stopUpdate()) : "portrait" === $(".orientation-msg-container").attr("data-orientation") ? ($(".orientation-msg-container").css("display", "none"), s_oMain.startUpdate()) : ($(".orientation-msg-container").css("display", "block"),
        s_oMain.stopUpdate()))
}

function createBitmap(a, c, b) {
    var d = new createjs.Bitmap(a),
        g = new createjs.Shape;
    c && b ? g.graphics.beginFill("#fff").drawRect(0, 0, c, b) : g.graphics.beginFill("#ff0").drawRect(0, 0, a.width, a.height);
    d.hitArea = g;
    return d
}

function createSprite(a, c, b, d, g, h) {
    a = null !== c ? new createjs.Sprite(a, c) : new createjs.Sprite(a);
    c = new createjs.Shape;
    c.graphics.beginFill("#000000").drawRect(-b, -d, g, h);
    a.hitArea = c;
    return a
}

function randomFloatBetween(a, c, b) {
    "undefined" === typeof b && (b = 2);
    return parseFloat(Math.min(a + Math.random() * (c - a), c).toFixed(b))
}

function tweenVectorsOnX(a, c, b) {
    return a + b * (c - a)
}

function shuffle(a) {
    for (var c = a.length, b, d; 0 !== c;) d = Math.floor(Math.random() * c), --c, b = a[c], a[c] = a[d], a[d] = b;
    return a
}

function bubbleSort(a) {
    do {
        var c = !1;
        for (var b = 0; b < a.length - 1; b++) a[b] > a[b + 1] && (c = a[b], a[b] = a[b + 1], a[b + 1] = c, c = !0)
    } while (c)
}

function compare(a, c) {
    return a.index > c.index ? -1 : a.index < c.index ? 1 : 0
}

function easeLinear(a, c, b, d) {
    return b * a / d + c
}

function easeInQuad(a, c, b, d) {
    return b * (a /= d) * a + c
}

function easeInSine(a, c, b, d) {
    return -b * Math.cos(a / d * (Math.PI / 2)) + b + c
}

function easeInCubic(a, c, b, d) {
    return b * (a /= d) * a * a + c
}

function getTrajectoryPoint(a, c) {
    var b = new createjs.Point,
        d = (1 - a) * (1 - a),
        g = a * a;
    b.x = d * c.start.x + 2 * (1 - a) * a * c.traj.x + g * c.end.x;
    b.y = d * c.start.y + 2 * (1 - a) * a * c.traj.y + g * c.end.y;
    return b
}

function formatTime(a) {
    a /= 1E3;
    var c = Math.floor(a / 60);
    a = parseFloat(a - 60 * c).toFixed(1);
    var b = "";
    b = 10 > c ? b + ("0" + c + ":") : b + (c + ":");
    return 10 > a ? b + ("0" + a) : b + a
}

function degreesToRadians(a) {
    return a * Math.PI / 180
}

function checkRectCollision(a, c) {
    var b = getBounds(a, .9);
    var d = getBounds(c, .98);
    return calculateIntersection(b, d)
}

function calculateIntersection(a, c) {
    var b, d, g, h;
    var f = a.x + (b = a.width / 2);
    var p = a.y + (d = a.height / 2);
    var m = c.x + (g = c.width / 2);
    var k = c.y + (h = c.height / 2);
    f = Math.abs(f - m) - (b + g);
    p = Math.abs(p - k) - (d + h);
    return 0 > f && 0 > p ? (f = Math.min(Math.min(a.width, c.width), -f), p = Math.min(Math.min(a.height, c.height), -p), {
        x: Math.max(a.x, c.x),
        y: Math.max(a.y, c.y),
        width: f,
        height: p,
        rect1: a,
        rect2: c
    }) : null
}

function getBounds(a, c) {
    var b = {
        x: Infinity,
        y: Infinity,
        width: 0,
        height: 0
    };
    if (a instanceof createjs.Container) {
        b.x2 = -Infinity;
        b.y2 = -Infinity;
        var d = a.children,
            g = d.length,
            h;
        for (h = 0; h < g; h++) {
            var f = getBounds(d[h], 1);
            f.x < b.x && (b.x = f.x);
            f.y < b.y && (b.y = f.y);
            f.x + f.width > b.x2 && (b.x2 = f.x + f.width);
            f.y + f.height > b.y2 && (b.y2 = f.y + f.height)
        }
        Infinity == b.x && (b.x = 0);
        Infinity == b.y && (b.y = 0);
        Infinity == b.x2 && (b.x2 = 0);
        Infinity == b.y2 && (b.y2 = 0);
        b.width = b.x2 - b.x;
        b.height = b.y2 - b.y;
        delete b.x2;
        delete b.y2
    } else {
        if (a instanceof createjs.Bitmap) {
            g =
                a.sourceRect || a.image;
            h = g.width * c;
            var p = g.height * c
        } else if (a instanceof createjs.Sprite)
            if (a.spriteSheet._frames && a.spriteSheet._frames[a.currentFrame] && a.spriteSheet._frames[a.currentFrame].image) {
                g = a.spriteSheet.getFrame(a.currentFrame);
                h = g.rect.width;
                p = g.rect.height;
                d = g.regX;
                var m = g.regY
            } else b.x = a.x || 0, b.y = a.y || 0;
        else b.x = a.x || 0, b.y = a.y || 0;
        d = d || 0;
        h = h || 0;
        m = m || 0;
        p = p || 0;
        b.regX = d;
        b.regY = m;
        g = a.localToGlobal(0 - d, 0 - m);
        f = a.localToGlobal(h - d, p - m);
        h = a.localToGlobal(h - d, 0 - m);
        d = a.localToGlobal(0 - d, p - m);
        b.x =
            Math.min(Math.min(Math.min(g.x, f.x), h.x), d.x);
        b.y = Math.min(Math.min(Math.min(g.y, f.y), h.y), d.y);
        b.width = Math.max(Math.max(Math.max(g.x, f.x), h.x), d.x) - b.x;
        b.height = Math.max(Math.max(Math.max(g.y, f.y), h.y), d.y) - b.y
    }
    return b
}

function NoClickDelay(a) {
    this.element = a;
    window.Touch && this.element.addEventListener("touchstart", this, !1)
}

function shuffle(a) {
    for (var c = a.length, b, d; 0 < c;) d = Math.floor(Math.random() * c), c--, b = a[c], a[c] = a[d], a[d] = b;
    return a
}
NoClickDelay.prototype = {
    handleEvent: function(a) {
        switch (a.type) {
            case "touchstart":
                this.onTouchStart(a);
                break;
            case "touchmove":
                this.onTouchMove(a);
                break;
            case "touchend":
                this.onTouchEnd(a)
        }
    },
    onTouchStart: function(a) {
        a.preventDefault();
        this.moved = !1;
        this.element.addEventListener("touchmove", this, !1);
        this.element.addEventListener("touchend", this, !1)
    },
    onTouchMove: function(a) {
        this.moved = !0
    },
    onTouchEnd: function(a) {
        this.element.removeEventListener("touchmove", this, !1);
        this.element.removeEventListener("touchend",
            this, !1);
        if (!this.moved) {
            a = document.elementFromPoint(a.changedTouches[0].clientX, a.changedTouches[0].clientY);
            3 == a.nodeType && (a = a.parentNode);
            var c = document.createEvent("MouseEvents");
            c.initEvent("click", !0, !0);
            a.dispatchEvent(c)
        }
    }
};
(function() {
    function a(a) {
        var b = {
            focus: "visible",
            focusin: "visible",
            pageshow: "visible",
            blur: "hidden",
            focusout: "hidden",
            pagehide: "hidden"
        };
        a = a || window.event;
        a.type in b ? document.body.className = b[a.type] : (document.body.className = this[c] ? "hidden" : "visible", "hidden" === document.body.className ? s_oMain.stopUpdate() : s_oMain.startUpdate())
    }
    var c = "hidden";
    c in document ? document.addEventListener("visibilitychange", a) : (c = "mozHidden") in document ? document.addEventListener("mozvisibilitychange", a) : (c = "webkitHidden") in
        document ? document.addEventListener("webkitvisibilitychange", a) : (c = "msHidden") in document ? document.addEventListener("msvisibilitychange", a) : "onfocusin" in document ? document.onfocusin = document.onfocusout = a : window.onpageshow = window.onpagehide = window.onfocus = window.onblur = a
})();

function playSound(a, c, b) {
    return !1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile ? (s_aSounds[a].play(), s_aSounds[a].volume(c), s_aSounds[a].loop(b), s_aSounds[a]) : null
}

function stopSound(a) {
    !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || s_aSounds[a].stop()
}

function setVolume(a, c) {
    !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || s_aSounds[a].volume(c)
}

function setMute(a, c) {
    !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || s_aSounds[a].mute(c)
}

function ctlArcadeResume() {
    null !== s_oMain && s_oMain.startUpdate()
}

function ctlArcadePause() {
    null !== s_oMain && s_oMain.stopUpdate()
}

function getParamValue(a) {
    for (var c = window.location.search.substring(1).split("&"), b = 0; b < c.length; b++) {
        var d = c[b].split("=");
        if (d[0] == a) return d[1]
    }
}

function fullscreenHandler() {
    ENABLE_FULLSCREEN && screenfull.enabled && (s_bFullscreen = screen.height < window.innerHeight + 3 && screen.height > window.innerHeight - 3 ? !0 : !1, null !== s_oInterface && s_oInterface.resetFullscreenBut(), null !== s_oMenu && s_oMenu.resetFullscreenBut())
}
if (screenfull.enabled) screenfull.on("change", function() {
    s_bFullscreen = screenfull.isFullscreen;
    null !== s_oInterface && s_oInterface.resetFullscreenBut();
    null !== s_oMenu && s_oMenu.resetFullscreenBut()
});

function CSpriteLibrary() {
    var a = {},
        c, b, d, g, h, f;
    this.init = function(a, m, k) {
        c = {};
        d = b = 0;
        g = a;
        h = m;
        f = k
    };
    this.addSprite = function(d, f) {
        if (!a.hasOwnProperty(d)) {
            var k = new Image;
            a[d] = c[d] = {
                szPath: f,
                oSprite: k,
                bLoaded: !1
            };
            b++
        }
    };
    this.getSprite = function(b) {
        return a.hasOwnProperty(b) ? a[b].oSprite : null
    };
    this._onSpritesLoaded = function() {
        b = 0;
        h.call(f)
    };
    this._onSpriteLoaded = function() {
        g.call(f);
        ++d === b && this._onSpritesLoaded()
    };
    this.loadSprites = function() {
        for (var a in c) c[a].oSprite.oSpriteLibrary = this, c[a].oSprite.szKey =
            a, c[a].oSprite.onload = function() {
                this.oSpriteLibrary.setLoaded(this.szKey);
                this.oSpriteLibrary._onSpriteLoaded(this.szKey)
            }, c[a].oSprite.onerror = function(a) {
                var b = a.currentTarget;
                setTimeout(function() {
                    c[b.szKey].oSprite.src = c[b.szKey].szPath
                }, 500)
            }, c[a].oSprite.src = c[a].szPath
    };
    this.setLoaded = function(b) {
        a[b].bLoaded = !0
    };
    this.isLoaded = function(b) {
        return a[b].bLoaded
    };
    this.getNumSprites = function() {
        return b
    }
}
var CANVAS_WIDTH = 1920,
    CANVAS_HEIGHT = 768,
    EDGEBOARD_X = 400,
    EDGEBOARD_Y = 0,
    FPS_TIME = 1E3 / 24,
    DISABLE_SOUND_MOBILE = !1,
    PRIMARY_FONT = "Arial",
    STATE_LOADING = 0,
    STATE_MENU = 1,
    STATE_HELP = 1,
    STATE_GAME = 3,
    ON_MOUSE_DOWN = 0,
    ON_MOUSE_UP = 1,
    ON_MOUSE_OVER = 2,
    ON_MOUSE_OUT = 3,
    ON_DRAG_START = 4,
    ON_DRAG_END = 5,
    INFO_PHASE = 0,
    END_PHASE = 1,
    INFO_PHASE_DURATION = 6E3,
    START_NUM_SHUFFLE, NUM_LEVEL_TO_INCREASE_NUM_SHUFFLE, START_TIMESPEED_SHUFFLE, DECREASE_TIMESPEED_SHUFFLE, MINIMUM_TIMESPEED, CARD_WIDTH = 216,
    CARD_HEIGHT = 330,
    SOUNDTRACK_VOLUME_IN_GAME =
    1,
    POINTS_TO_WIN, ENABLE_FULLSCREEN, ENABLE_CHECK_ORIENTATION, SHOW_CREDITS;
TEXT_GAMEOVER = "WRONG CHOICE, YOU'RE OUT!";
TEXT_SCORE = "SCORE";
TEXT_BEST_SCORE = "BEST SCORE";
TEXT_CUR_SCORE = "CURRENT SCORE";
TEXT_PLAY = "PLAY";
TEXT_RESTART = "RESTART";
TEXT_CHOOSE = "WHERE IS THE ACE OF HEARTS?";
TEXT_INFO = "FIND THE ACE OF HEARTS!";
TEXT_SHUFFLE = "SHUFFLING...";
TEXT_WIN = "WELL DONE!";
TEXT_HELP1 = "GAMES RULES ARE SIMPLE:";
TEXT_HELP2 = "FIND THE ACE OF HEARTS, IF YOU MISS IT, YOU ARE OUT!";
TEXT_CREDITS_DEVELOPED = "DEVELOPED BY";
var TEXT_PRELOADER_CONTINUE = "START";

function CPreloader() {
    var a, c, b, d, g, h, f, p, m, k;
    this._init = function() {
        s_oSpriteLibrary.init(this._onImagesLoaded, this._onAllImagesLoaded, this);
        s_oSpriteLibrary.addSprite("progress_bar", "./sprites/progress_bar.png");
        s_oSpriteLibrary.addSprite("200x200", "./sprites/200x200.jpg");
        s_oSpriteLibrary.addSprite("but_start", "./sprites/but_start.png");
        s_oSpriteLibrary.loadSprites();
        k = new createjs.Container;
        s_oStage.addChild(k)
    };
    this.unload = function() {
        k.removeAllChildren();
        m.unload()
    };
    this._onImagesLoaded = function() {};
    this._onAllImagesLoaded = function() {
        this.attachSprites();
        s_oMain.preloaderReady()
    };
    this.attachSprites = function() {
        var x = new createjs.Shape;
        x.graphics.beginFill("black").drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
        k.addChild(x);
        x = s_oSpriteLibrary.getSprite("200x200");
        f = createBitmap(x);
        f.regX = .5 * x.width;
        f.regY = .5 * x.height;
        f.x = CANVAS_WIDTH / 2;
        f.y = CANVAS_HEIGHT / 2 - 180;
        k.addChild(f);
        p = new createjs.Shape;
        p.graphics.beginFill("rgba(0,0,0,0.01)").drawRoundRect(f.x - 100, f.y - 100, 200, 200, 10);
        k.addChild(p);
        f.mask = p;
        x = s_oSpriteLibrary.getSprite("progress_bar");
        d = createBitmap(x);
        d.x = CANVAS_WIDTH / 2 - x.width / 2;
        d.y = CANVAS_HEIGHT / 2 + 50;
        k.addChild(d);
        a = x.width;
        c = x.height;
        g = new createjs.Shape;
        g.graphics.beginFill("rgba(0,0,0,0.01)").drawRect(d.x, d.y, 1, c);
        k.addChild(g);
        d.mask = g;
        b = new createjs.Text("", "40px " + PRIMARY_FONT, "#fff");
        b.x = CANVAS_WIDTH / 2;
        b.y = CANVAS_HEIGHT / 2 + 110;
        b.textBaseline = "alphabetic";
        b.textAlign = "center";
        k.addChild(b);
        x = s_oSpriteLibrary.getSprite("but_start");
        m = new CTextButton(CANVAS_WIDTH / 2, CANVAS_HEIGHT /
            2, x, TEXT_PRELOADER_CONTINUE, "Arial", "#000", "bold 50", k);
        m.addEventListener(ON_MOUSE_UP, this._onButStartRelease, this);
        m.setVisible(!1);
        h = new createjs.Shape;
        h.graphics.beginFill("black").drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
        k.addChild(h);
        createjs.Tween.get(h).to({
            alpha: 0
        }, 500).call(function() {
            createjs.Tween.removeTweens(h);
            k.removeChild(h)
        })
    };
    this._onButStartRelease = function() {
        s_oMain._onRemovePreloader()
    };
    this.refreshLoader = function(f) {
        b.text = f + "%";
        100 === f && (s_oMain._onRemovePreloader(), b.visible = !1, d.visible = !1);
        g.graphics.clear();
        f = Math.floor(f * a / 100);
        g.graphics.beginFill("rgba(0,0,0,0.01)").drawRect(d.x, d.y, f, c)
    };
    this._init()
}

function CMain(a) {
    var c, b = 0,
        d = 0,
        g = STATE_LOADING,
        h, f;
    this.initContainer = function() {
        s_oCanvas = document.getElementById("canvas");
        s_oStage = new createjs.Stage(s_oCanvas);
        createjs.Touch.enable(s_oStage);
        s_bMobile = jQuery.browser.mobile;
        !1 === s_bMobile && (s_oStage.enableMouseOver(20), $("body").on("contextmenu", "#canvas", function(a) {
            return !1
        }));
        s_iPrevTime = (new Date).getTime();
        createjs.Ticker.addEventListener("tick", this._update);
        createjs.Ticker.framerate = 30;
        navigator.userAgent.match(/Windows Phone/i) && (DISABLE_SOUND_MOBILE = !0);
        s_oSpriteLibrary = new CSpriteLibrary;
		h = new CPreloader;
       // seekAndDestroy() ? h = new CPreloader : window.location.href = "http://www.codethislab.com/contact-us.html"
    };
    this.preloaderReady = function() {
        !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || this._initSounds();
        this._loadImages();
        c = !0
    };
    this.soundLoaded = function() {
        b++;
        h.refreshLoader(Math.floor(b / d * 100))
    };
    this._initSounds = function() {
        Howler.mute(!s_bAudioActive);
        s_aSoundsInfo = [];
        s_aSoundsInfo.push({
            path: "./sounds/",
            filename: "game_over",
            loop: !1,
            volume: 1,
            ingamename: "game_over"
        });
        s_aSoundsInfo.push({
            path: "./sounds/",
            filename: "press_button",
            loop: !1,
            volume: 1,
            ingamename: "press_button"
        });
        s_aSoundsInfo.push({
            path: "./sounds/",
            filename: "card",
            loop: !1,
            volume: 1,
            ingamename: "card"
        });
        s_aSoundsInfo.push({
            path: "./sounds/",
            filename: "shuffle",
            loop: !1,
            volume: 1,
            ingamename: "shuffle"
        });
        s_aSoundsInfo.push({
            path: "./sounds/",
            filename: "soundtrack",
            loop: !0,
            volume: 1,
            ingamename: "soundtrack"
        });
        d += s_aSoundsInfo.length;
        s_aSounds = [];
        for (var a = 0; a < s_aSoundsInfo.length; a++) this.tryToLoadSound(s_aSoundsInfo[a],
            !1)
    };
    this.tryToLoadSound = function(a, b) {
        setTimeout(function() {
            s_aSounds[a.ingamename] = new Howl({
                src: [a.path + a.filename + ".mp3"],
                autoplay: !1,
                preload: !0,
                loop: a.loop,
                volume: a.volume,
                onload: s_oMain.soundLoaded,
                onloaderror: function(a, b) {
                    for (var c = 0; c < s_aSoundsInfo.length; c++)
                        if (a === s_aSounds[s_aSoundsInfo[c].ingamename]._sounds[0]._id) {
                            s_oMain.tryToLoadSound(s_aSoundsInfo[c], !0);
                            break
                        }
                },
                onplayerror: function(a) {
                    for (var b = 0; b < s_aSoundsInfo.length; b++)
                        if (a === s_aSounds[s_aSoundsInfo[b].ingamename]._sounds[0]._id) {
                            s_aSounds[s_aSoundsInfo[b].ingamename].once("unlock",
                                function() {
                                    s_aSounds[s_aSoundsInfo[b].ingamename].play();
                                    "soundtrack" === s_aSoundsInfo[b].ingamename && null !== s_oGame && setVolume("soundtrack", SOUNDTRACK_VOLUME_IN_GAME)
                                });
                            break
                        }
                }
            })
        }, b ? 200 : 0)
    };
    this._loadImages = function() {
        s_oSpriteLibrary.init(this._onImagesLoaded, this._onAllImagesLoaded, this);
        s_oSpriteLibrary.addSprite("but_play", "./sprites/but_play.png");
        s_oSpriteLibrary.addSprite("msg_box", "./sprites/msg_box.png");
        s_oSpriteLibrary.addSprite("bg_menu", "./sprites/bg_menu.jpg");
        s_oSpriteLibrary.addSprite("bg_game",
            "./sprites/bg_game.jpg");
        s_oSpriteLibrary.addSprite("bg_help", "./sprites/bg_help.png");
        s_oSpriteLibrary.addSprite("but_exit", "./sprites/but_exit.png");
        s_oSpriteLibrary.addSprite("audio_icon", "./sprites/audio_icon.png");
        s_oSpriteLibrary.addSprite("score_panel", "./sprites/score_panel.png");
        s_oSpriteLibrary.addSprite("card_back", "./sprites/card_back.png");
        s_oSpriteLibrary.addSprite("hearts", "./sprites/hearts.png");
        s_oSpriteLibrary.addSprite("clubs", "./sprites/clubs.png");
        s_oSpriteLibrary.addSprite("spades",
            "./sprites/spades.png");
        s_oSpriteLibrary.addSprite("heart_lose", "./sprites/heart_lose.png");
        s_oSpriteLibrary.addSprite("but_fullscreen", "./sprites/but_fullscreen.png");
        s_oSpriteLibrary.addSprite("but_credits", "./sprites/but_credits.png");
        s_oSpriteLibrary.addSprite("logo_credits", "./sprites/logo_credits.png");
        d += s_oSpriteLibrary.getNumSprites();
        s_oSpriteLibrary.loadSprites()
    };
    this._onImagesLoaded = function() {
        b++;
        h.refreshLoader(Math.floor(b / d * 100))
    };
    this._onAllImagesLoaded = function() {};
    this.onAllPreloaderImagesLoaded =
        function() {
            this._loadImages()
        };
    this._onRemovePreloader = function() {
        h.unload();
        s_oSoundTrack = playSound("soundtrack", 1, !0);
        this.gotoMenu()
    };
    this.gotoMenu = function() {
        new CMenu;
        g = STATE_MENU
    };
    this.gotoGame = function(a) {
        s_bEasyMode = a;
        f = new CGame(p);
        g = STATE_GAME
    };
    this.gotoHelp = function() {
        new CHelp;
        g = STATE_HELP
    };
    this.stopUpdate = function() {
        c = !1;
        createjs.Ticker.paused = !0;
        $("#block_game").css("display", "block");
        !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || Howler.mute(!0)
    };
    this.startUpdate = function() {
        s_iPrevTime =
            (new Date).getTime();
        c = !0;
        createjs.Ticker.paused = !1;
        $("#block_game").css("display", "none");
        (!1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile) && s_bAudioActive && Howler.mute(!1)
    };
    this._update = function(a) {
        if (!1 !== c) {
            var b = (new Date).getTime();
            s_iTimeElaps = b - s_iPrevTime;
            s_iCntTime += s_iTimeElaps;
            s_iCntFps++;
            s_iPrevTime = b;
            1E3 <= s_iCntTime && (s_iCurFps = s_iCntFps, s_iCntTime -= 1E3, s_iCntFps = 0);
            g === STATE_GAME && f.update();
            s_oStage.update(a)
        }
    };
    s_oMain = this;
    var p = a;
    ENABLE_FULLSCREEN = p.fullscreen;
    ENABLE_CHECK_ORIENTATION =
        p.check_orientation;
    SHOW_CREDITS = a.show_credits;
    s_bAudioActive = a.audio_enable_on_startup;
    this.initContainer()
}
var s_bMobile, s_bEasyMode, s_bAudioActive = !0,
    s_iCntTime = 0,
    s_iTimeElaps = 0,
    s_iPrevTime = 0,
    s_iCntFps = 0,
    s_iCurFps = 0,
    s_iBestScore = 0,
    s_oDrawLayer, s_oStage, s_oMain, s_oSpriteLibrary, s_oSoundTrack = null,
    s_oCanvas, s_bFullscreen = !1,
    s_aSoundsInfo;

function CTextButton(a, c, b, d, g, h, f, p) {
    var m, k, x, l, r, v, w, B, t, y, D, G;
    this._init = function(a, b, c, d, f, g, h, p) {
        m = !1;
        l = [];
        r = [];
        G = createBitmap(c);
        k = c.width;
        x = c.height;
        var w = Math.ceil(h / 20);
        y = new createjs.Text(d, h + "px " + f, "#000000");
        var u = y.getBounds();
        y.textAlign = "center";
        y.lineWidth = .9 * k;
        y.textBaseline = "alphabetic";
        y.x = c.width / 2 + w;
        y.y = Math.floor(c.height / 2) + u.height / 3 + w;
        D = new createjs.Text(d, h + "px " + f, g);
        D.textAlign = "center";
        D.textBaseline = "alphabetic";
        D.lineWidth = .9 * k;
        D.x = c.width / 2;
        D.y = Math.floor(c.height /
            2) + u.height / 3;
        t = new createjs.Container;
        t.x = a;
        t.y = b;
        t.regX = c.width / 2;
        t.regY = c.height / 2;
        s_bMobile || (t.cursor = "pointer");
        t.addChild(G, y, D);
        !1 !== p && s_oStage.addChild(t);
        this._initListener()
    };
    this.unload = function() {
        t.off("mousedown", v);
        t.off("pressup", w);
        s_oStage.removeChild(t)
    };
    this.setVisible = function(a) {
        t.visible = a
    };
    this.setAlign = function(a) {
        D.textAlign = a;
        y.textAlign = a
    };
    this.enable = function() {
        m = !1;
        G.filters = [];
        G.cache(0, 0, k, x)
    };
    this.disable = function() {
        m = !0;
        var a = (new createjs.ColorMatrix).adjustSaturation(-100).adjustBrightness(40);
        G.filters = [new createjs.ColorMatrixFilter(a)];
        G.cache(0, 0, k, x)
    };
    this._initListener = function() {
        v = t.on("mousedown", this.buttonDown);
        w = t.on("pressup", this.buttonRelease)
    };
    this.addEventListener = function(a, b, c) {
        l[a] = b;
        r[a] = c
    };
    this.addEventListenerWithParams = function(a, b, c, d) {
        l[a] = b;
        r[a] = c;
        B = d
    };
    this.buttonRelease = function() {
        m || (playSound("press_button", 1, !1), t.scaleX = 1, t.scaleY = 1, l[ON_MOUSE_UP] && l[ON_MOUSE_UP].call(r[ON_MOUSE_UP], B))
    };
    this.buttonDown = function() {
        m || (t.scaleX = .9, t.scaleY = .9, l[ON_MOUSE_DOWN] &&
            l[ON_MOUSE_DOWN].call(r[ON_MOUSE_DOWN]))
    };
    this.setPosition = function(a, b) {
        t.x = a;
        t.y = b
    };
    this.changeText = function(a) {
        D.text = a;
        y.text = a
    };
    this.setX = function(a) {
        t.x = a
    };
    this.setY = function(a) {
        t.y = a
    };
    this.getButtonImage = function() {
        return t
    };
    this.getX = function() {
        return t.x
    };
    this.getY = function() {
        return t.y
    };
    this.getSprite = function() {
        return t
    };
    this._init(a, c, b, d, g, h, f, p);
    return this
}

function CToggle(a, c, b, d, g) {
    var h, f, p, m;
    this._init = function(a, b, c, d) {
        f = [];
        p = [];
        var k = new createjs.SpriteSheet({
            images: [c],
            frames: {
                width: c.width / 2,
                height: c.height,
                regX: c.width / 2 / 2,
                regY: c.height / 2
            },
            animations: {
                state_true: [0],
                state_false: [1]
            }
        });
        h = d;
        m = createSprite(k, "state_" + h, c.width / 2 / 2, c.height / 2, c.width / 2, c.height);
        m.x = a;
        m.y = b;
        m.stop();
        m.cursor = "pointer";
        g.addChild(m);
        this._initListener()
    };
    this.unload = function() {
        m.off("mousedown", this.buttonDown);
        m.off("pressup", this.buttonRelease);
        g.removeChild(m)
    };
    this._initListener = function() {
        m.on("mousedown", this.buttonDown);
        m.on("pressup", this.buttonRelease)
    };
    this.addEventListener = function(a, b, c) {
        f[a] = b;
        p[a] = c
    };
    this.setActive = function(a) {
        h = a;
        m.gotoAndStop("state_" + h)
    };
    this.buttonRelease = function() {
        m.scaleX = 1;
        m.scaleY = 1;
        playSound("press_button", 1, !1);
        h = !h;
        m.gotoAndStop("state_" + h);
        f[ON_MOUSE_UP] && f[ON_MOUSE_UP].call(p[ON_MOUSE_UP], h)
    };
    this.buttonDown = function() {
        m.scaleX = .9;
        m.scaleY = .9;
        f[ON_MOUSE_DOWN] && f[ON_MOUSE_DOWN].call(p[ON_MOUSE_DOWN])
    };
    this.setPosition =
        function(a, b) {
            m.x = a;
            m.y = b
        };
    this._init(a, c, b, d)
}

function CGfxButton(a, c, b, d) {
    var g, h, f;
    this._init = function(a, b, c) {
        g = [];
        h = [];
        f = createBitmap(c);
        f.x = a;
        f.y = b;
        f.regX = c.width / 2;
        f.regY = c.height / 2;
        f.cursor = "pointer";
        d.addChild(f);
        this._initListener()
    };
    this.unload = function() {
        f.off("mousedown", this.buttonDown);
        f.off("pressup", this.buttonRelease);
        d.removeChild(f)
    };
    this.setVisible = function(a) {
        f.visible = a
    };
    this._initListener = function() {
        f.on("mousedown", this.buttonDown);
        f.on("pressup", this.buttonRelease)
    };
    this.addEventListener = function(a, b, c) {
        g[a] = b;
        h[a] = c
    };
    this.buttonRelease = function() {
        f.scaleX = 1;
        f.scaleY = 1;
        playSound("press_button", 1, !1);
        g[ON_MOUSE_UP] && g[ON_MOUSE_UP].call(h[ON_MOUSE_UP])
    };
    this.buttonDown = function() {
        f.scaleX = .9;
        f.scaleY = .9;
        g[ON_MOUSE_DOWN] && g[ON_MOUSE_DOWN].call(h[ON_MOUSE_DOWN])
    };
    this.setPosition = function(a, b) {
        f.x = a;
        f.y = b
    };
    this.setX = function(a) {
        f.x = a
    };
    this.setY = function(a) {
        f.y = a
    };
    this.getButtonImage = function() {
        return f
    };
    this.getX = function() {
        return f.x
    };
    this.getY = function() {
        return f.y
    };
    this._init(a, c, b);
    return this
}

function CMenu() {
    var a, c, b, d, g, h, f, p, m, k, x, l, r = null,
        v = null;
    this._init = function() {
        f = createBitmap(s_oSpriteLibrary.getSprite("bg_menu"));
        s_oStage.addChild(f);
        var w = s_oSpriteLibrary.getSprite("but_play");
        p = new CGfxButton(CANVAS_WIDTH / 2, CANVAS_HEIGHT - 160, w, s_oStage);
        p.addEventListener(ON_MOUSE_UP, this._onButPlayRelease, this);
        !1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile ? (w = s_oSpriteLibrary.getSprite("audio_icon"), g = CANVAS_WIDTH - w.height / 2 - 10, h = w.height / 2 + 10, k = new CToggle(g, h, w, s_bAudioActive, s_oStage), k.addEventListener(ON_MOUSE_UP,
            this._onAudioToggle, this), w = s_oSpriteLibrary.getSprite("but_fullscreen"), a = g - w.width / 2 - 10) : (w = s_oSpriteLibrary.getSprite("but_fullscreen"), a = CANVAS_WIDTH - w.height / 2 - 10);
        c = w.height / 2 + 10;
        var B = window.document,
            t = B.documentElement;
        r = t.requestFullscreen || t.mozRequestFullScreen || t.webkitRequestFullScreen || t.msRequestFullscreen;
        v = B.exitFullscreen || B.mozCancelFullScreen || B.webkitExitFullscreen || B.msExitFullscreen;
        !1 === ENABLE_FULLSCREEN && (r = !1);
        r && screenfull.enabled && (l = new CToggle(a, c, w, s_bFullscreen, s_oStage),
            l.addEventListener(ON_MOUSE_UP, this._onFullscreenRelease, this));
        SHOW_CREDITS && (w = s_oSpriteLibrary.getSprite("but_credits"), b = w.width / 2 + 10, d = w.height / 2 + 10, x = new CGfxButton(b, d, w, s_oStage), x.addEventListener(ON_MOUSE_UP, this._onCredits, this));
        m = new createjs.Shape;
        m.graphics.beginFill("black").drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
        s_oStage.addChild(m);
        createjs.Tween.get(m).to({
            alpha: 0
        }, 1E3).call(function() {
            m.visible = !1
        });
        this.refreshButtonPos(s_iOffsetX, s_iOffsetY)
    };
    this.refreshButtonPos = function(f,
        m) {
        !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || k.setPosition(g - f, m + h);
        r && screenfull.enabled && l.setPosition(a - f, c + m);
        SHOW_CREDITS && x.setPosition(b + s_iOffsetX, d + s_iOffsetY)
    };
    this.unload = function() {
        p.unload();
        p = null;
        SHOW_CREDITS && x.unload();
        if (!1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile) k.unload(), k = null;
        r && screenfull.enabled && l.unload();
        s_oStage.removeChild(f);
        s_oMenu = f = null
    };
    this._onAudioToggle = function() {
        Howler.mute(s_bAudioActive);
        s_bAudioActive = !s_bAudioActive
    };
    this._onButPlayRelease = function() {
        $(s_oMain).trigger("start_session");
        $(s_oMain).trigger("start_level", 1);
        this.unload();
        s_oMain.gotoGame()
    };
    this.resetFullscreenBut = function() {
        r && screenfull.enabled && l.setActive(s_bFullscreen)
    };
    this._onFullscreenRelease = function() {
        s_bFullscreen ? v.call(window.document) : r.call(window.document.documentElement);
        sizeHandler()
    };
    this._onCredits = function() {
        new CCreditsPanel
    };
    s_oMenu = this;
    this._init()
}
var s_oMenu = null;

function CGame(a) {
    var c, b, d, g, h, f, p, m, k, x, l, r, v, w, B = null,
        t;
    this._init = function() {
        b = c = !0;
        d = !1;
        k = m = p = f = g = 0;
        x = START_NUM_SHUFFLE;
        v = [];
        var a = createBitmap(s_oSpriteLibrary.getSprite("bg_game"));
        s_oStage.addChild(a);
        t = new createjs.Container;
        s_oStage.addChild(t);
        w = new CInterface;
        w.refreshBestScore(s_iBestScore);
        l = [];
        l[0] = {
            x: CANVAS_WIDTH / 2 - 60 - CARD_WIDTH,
            y: CANVAS_HEIGHT / 2
        };
        l[1] = {
            x: CANVAS_WIDTH / 2,
            y: CANVAS_HEIGHT / 2
        };
        l[2] = {
            x: CANVAS_WIDTH / 2 + 60 + CARD_WIDTH,
            y: CANVAS_HEIGHT / 2
        };
        this._shuffleCards();
        new CHelpPanel
    };
    this._shuffleCards = function() {
        r = [];
        for (var a = 0; 3 > a; a++) r[a] = a;
        shuffle(r);
        for (a = 0; 3 > a; a++) v[a] = new CCard(l[r[a]].x, l[r[a]].y, t, r[a], a)
    };
    this.updateScore = function(a) {
        g += a;
        0 > g && (g = 0);
        w.refreshCurScore(g)
    };
    this.unload = function() {
        c = !1;
        w.unload();
        null !== B && B.unload();
        for (var a = 0; a < v.length; a++) v[a].unload();
        createjs.Tween.removeAllTweens();
        s_oStage.removeAllChildren()
    };
    this.onExit = function() {
        this.unload();
        s_oMain.gotoMenu();
        $(s_oMain).trigger("show_interlevel_ad")
    };
    this._onExitHelp = function() {
        c = !0;
        h = INFO_PHASE
    };
    this.gameOver = function(a) {
        h = null;
        for (var b = 0; b < v.length; b++) v[b].getLogicPos() !== a.iLogicPos && v[b].showDelayedCard();
        B = CEndPanel(s_oSpriteLibrary.getSprite("msg_box"));
        B.show(g);
        g > s_iBestScore && (s_iBestScore = g)
    };
    this._infoPhase = function() {
        f += s_iTimeElaps;
        if (f >= INFO_PHASE_DURATION / 4 && f < 2 * INFO_PHASE_DURATION / 4 && b) {
            b = !1;
            d = !0;
            w.showText(!0, TEXT_INFO);
            for (var a = 0; a < v.length; a++) v[a].getStateTurned() || v[a].showCard()
        } else if (f >= 3 * INFO_PHASE_DURATION / 4 && f < INFO_PHASE_DURATION && d)
            for (d = !1, w.showText(!1, TEXT_INFO),
                a = 0; a < v.length; a++) v[a].hideCard();
        else f >= INFO_PHASE_DURATION && (f = 0, d = b = !0, h = null, w.showText(!0, TEXT_SHUFFLE), this._shufflePhase())
    };
    this.checkShuffle = function() {
        m++;
        2 === m && (m = 0, p++, p < x ? this._shufflePhase() : (p = 0, w.showText(!1, TEXT_SHUFFLE), this._choosePhase()))
    };
    this._shufflePhase = function() {
        playSound("shuffle", 1, !1);
        shuffle(r);
        var a = v[r[0]].getLogicPos(),
            b = v[r[1]].getLogicPos();
        t.setChildIndex(v[r[2]].getSprite(), 0);
        var c = Math.random();
        if (t.getChildIndex(v[r[0]].getSprite()) > t.getChildIndex(v[r[1]].getSprite())) {
            var d =
                1.1;
            var f = 1
        } else d = 1, f = 1.1;
        var g = START_TIMESPEED_SHUFFLE + k * DECREASE_TIMESPEED_SHUFFLE;
        g < MINIMUM_TIMESPEED && (g = 200);
        var h = .5 > Math.random() ? 1 : -1;
        v[r[0]].moveCard(l[b].x, l[b].y, g, b, h, d, c);
        v[r[1]].moveCard(l[a].x, l[a].y, g, a, -h, f, c)
    };
    this._choosePhase = function() {
        w.showText(!0, TEXT_CHOOSE);
        for (var a = 0; a < v.length; a++) v[a].activeHitArea(!0)
    };
    this.checkWin = function(a, b) {
        w.showText(!1, TEXT_CHOOSE);
        for (var c = 0; c < v.length; c++) v[c].getLogicPos() === b.iLogicPos && v[c].showCard(), v[c].activeHitArea(!1);
        "hearts" ===
        b.szCardType ? (w.showText(!0, TEXT_WIN), this.updateScore(POINTS_TO_WIN), h = END_PHASE) : this.gameOver(b)
    };
    this._endPhase = function() {
        k++;
        0 === k % NUM_LEVEL_TO_INCREASE_NUM_SHUFFLE && x++;
        h = INFO_PHASE
    };
    this.update = function() {
        if (c) switch (h) {
            case INFO_PHASE:
                this._infoPhase();
                break;
            case END_PHASE:
                this._endPhase()
        }
    };
    s_oGame = this;
    POINTS_TO_LOSE = a.points_to_lose;
    POINTS_TO_WIN = a.points_to_win;
    START_NUM_SHUFFLE = a.start_num_shuffle;
    NUM_LEVEL_TO_INCREASE_NUM_SHUFFLE = a.num_level_to_increase_num_shuffle;
    START_TIMESPEED_SHUFFLE =
        a.start_timespeed_shuffle;
    DECREASE_TIMESPEED_SHUFFLE = a.decrease_timespeed_shuffle;
    MINIMUM_TIMESPEED = a.minimum_timespeed;
    this._init()
}
var s_oGame;

function CInterface() {
    var a, c, b, d, g, h, f, p, m, k, x, l, r, v, w = null,
        B = null;
    this._init = function() {
        var t = s_oSpriteLibrary.getSprite("but_exit");
        g = CANVAS_WIDTH - t.height / 2 - 10;
        h = t.height / 2 + 10;
        p = new CGfxButton(g, h, t, s_oStage);
        p.addEventListener(ON_MOUSE_UP, this._onExit, this);
        var y = CANVAS_WIDTH - t.width / 2 - 80;
        if (!1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile) t = s_oSpriteLibrary.getSprite("audio_icon"), b = y, d = t.height / 2 + 10, f = new CToggle(b, d, t, s_bAudioActive, s_oStage), f.addEventListener(ON_MOUSE_UP, this._onAudioToggle, this);
        y = window.document;
        t = y.documentElement;
        w = t.requestFullscreen || t.mozRequestFullScreen || t.webkitRequestFullScreen || t.msRequestFullscreen;
        B = y.exitFullscreen || y.mozCancelFullScreen || y.webkitExitFullscreen || y.msExitFullscreen;
        !1 === ENABLE_FULLSCREEN && (w = !1);
        w && screenfull.enabled && (t = s_oSpriteLibrary.getSprite("but_fullscreen"), a = t.width / 4 + 10, c = t.height / 2 + 10, v = new CToggle(a, c, t, s_bFullscreen, s_oStage), v.addEventListener(ON_MOUSE_UP, this._onFullscreenRelease, this));
        y = createBitmap(s_oSpriteLibrary.getSprite("score_panel"));
        y.x = 520;
        y.y = 600;
        s_oStage.addChild(y);
        new CTLText(s_oStage, 526, 610, 180, 20, 20, "center", "#fff", PRIMARY_FONT, 1, 0, 0, TEXT_BEST_SCORE, !0, !0, !1, !1);
        m = new CTLText(s_oStage, 526, 640, 180, 24, 24, "center", "#fff", PRIMARY_FONT, 1, 0, 0, "0", !0, !0, !1, !1);
        y = createBitmap(s_oSpriteLibrary.getSprite("score_panel"));
        y.x = 1200;
        y.y = 600;
        s_oStage.addChild(y);
        new CTLText(s_oStage, 1206, 610, 180, 20, 20, "center", "#fff", PRIMARY_FONT, 1, 0, 0, TEXT_CUR_SCORE, !0, !0, !1, !1);
        k = new CTLText(s_oStage, 1206, 640, 180, 24, 24, "center", "#fff", PRIMARY_FONT,
            1, 0, 0, "0", !0, !0, !1, !1);
        r = new createjs.Container;
        r.x = CANVAS_WIDTH / 2;
        r.y = 90;
        r.visible = !1;
        s_oStage.addChild(r);
        x = new CTLText(r, -396, 4, 800, 100, 50, "center", "#000", PRIMARY_FONT, 1, 0, 0, TEXT_CHOOSE, !0, !0, !0, !1);
        l = new CTLText(r, -400, 0, 800, 100, 50, "center", "#fff", PRIMARY_FONT, 1, 0, 0, TEXT_CHOOSE, !0, !0, !0, !1);
        this.refreshButtonPos(s_iOffsetX, s_iOffsetY)
    };
    this.refreshButtonPos = function(k, l) {
        p.setPosition(g - k, h + l);
        !1 !== DISABLE_SOUND_MOBILE && !1 !== s_bMobile || f.setPosition(b - k, d + l);
        w && screenfull.enabled && v.setPosition(a +
            k, c + l)
    };
    this.unload = function() {
        if (!1 === DISABLE_SOUND_MOBILE || !1 === s_bMobile) f.unload(), f = null;
        w && screenfull.enabled && v.unload();
        p.unload();
        s_oInterface = null
    };
    this.refreshBestScore = function(a) {
        m.refreshText(a)
    };
    this.refreshCurScore = function(a) {
        k.refreshText(a)
    };
    this.showText = function(a, b) {
        r.visible = a;
        l.refreshText(b);
        x.refreshText(b)
    };
    this._onButRestartRelease = function() {
        $(s_oMain).trigger("restart_level", 1);
        s_oGame.restartGame()
    };
    this._onAudioToggle = function() {
        Howler.mute(s_bAudioActive);
        s_bAudioActive = !s_bAudioActive
    };
    this._onExit = function() {
        $(s_oMain).trigger("end_session");
        $(s_oMain).trigger("end_level", 1);
        s_oGame.onExit()
    };
    this.resetFullscreenBut = function() {
        w && screenfull.enabled && v.setActive(s_bFullscreen)
    };
    this._onFullscreenRelease = function() {
        s_bFullscreen ? B.call(window.document) : w.call(window.document.documentElement);
        sizeHandler()
    };
    s_oInterface = this;
    this._init();
    return this
}
var s_oInterface = null;

function CHelpPanel() {
    var a, c;
    this._init = function() {
        var b = this;
        c = new createjs.Container;
        c.addChild(a);
        c.alpha = 0;
        c.on("pressup", function() {
            b._onExitHelp()
        });
        s_oStage.addChild(c);
        a = createBitmap(s_oSpriteLibrary.getSprite("bg_help"));
        c.addChild(a);
        new CTLText(c, CANVAS_WIDTH / 2 - 250, CANVAS_HEIGHT / 2 - 190, 500, 100, 30, "center", "#fff", PRIMARY_FONT, 1, 0, 0, TEXT_HELP1, !0, !0, !0, !1);
        new CTLText(c, CANVAS_WIDTH / 2 - 250, CANVAS_HEIGHT / 2 - 60, 500, 100, 30, "center", "#fff", PRIMARY_FONT, 1, 0, 0, TEXT_HELP2, !0, !0, !0, !1);
        createjs.Tween.get(c).to({
                alpha: 1
            },
            700)
    };
    this.unload = function() {
        s_oStage.removeChild(c);
        var a = this;
        c.off("pressup", function() {
            a._onExitHelp()
        })
    };
    this._onExitHelp = function() {
        b.unload();
        s_oGame._onExitHelp()
    };
    var b = this;
    this._init()
}

function CEndPanel(a) {
    var c, b, d, g, h;
    this._init = function(a) {
        b = new createjs.Container;
        b.alpha = 0;
        b.visible = !1;
        s_oStage.addChild(b);
        c = createBitmap(a);
        b.addChild(c);
        var f = s_oSpriteLibrary.getSprite("heart_lose");
        h = createBitmap(f);
        h.regX = f.width / 2;
        h.x = a.width / 2;
        h.y = 314;
        b.addChild(h);
        d = new CTLText(b, CANVAS_WIDTH / 2 - 250, CANVAS_HEIGHT / 2 - 190, 500, 100, 50, "center", "#fff", PRIMARY_FONT, 1, 0, 0, " ", !0, !0, !0, !1);
        g = new CTLText(b, CANVAS_WIDTH / 2 - 250, CANVAS_HEIGHT / 2 + 130, 500, 80, 40, "center", "#fff", PRIMARY_FONT, 1, 0, 0, " ", !0,
            !0, !0, !1)
    };
    this.unload = function() {
        b.off("mousedown", this._onExit)
    };
    this._initListener = function(a) {
        b.on("mousedown", this._onExit);
        var c = "You collected <strong>" + a + " points</strong>!<br><br>Share your score with your friends!",
            d = "My score is " + a + " points! Can you do better";
        $(s_oMain).trigger("share_event", [a, "200x200.jpg", "Congratulations!", c, d])
    };
    this.show = function(a) {
        playSound("game_over", 1, !1);
        d.refreshText(TEXT_GAMEOVER);
        g.refreshText(TEXT_SCORE + ": " + a);
        b.visible = !0;
        var c = this;
        createjs.Tween.get(b).wait(2500).to({
                alpha: 1
            },
            500).call(function() {
            c._initListener(a)
        });
        $(s_oMain).trigger("save_score", a);
        $(s_oMain).trigger("end_level", 1)
    };
    this._onExit = function() {
        $(s_oMain).trigger("end_session");
        b.off("mousedown", this._onExit);
        s_oStage.removeChild(b);
        s_oGame.onExit()
    };
    this._init(a);
    return this
}

function CCard(a, c, b, d, g) {
    var h, f, p, m, k, x, l, r;
    this._init = function(a, b, c, d, g) {
        h = !1;
        f = 0 === g ? "hearts" : 1 === g ? "clubs" : "spades";
        p = d;
        r = c;
        l = new createjs.Container;
        l.x = a;
        l.y = b;
        l.regX = CARD_WIDTH / 2;
        l.regY = CARD_HEIGHT / 2;
        r.addChild(l);
        a = s_oSpriteLibrary.getSprite("card_back");
        m = createBitmap(a);
        m.visible = !0;
        l.addChild(m);
        a = s_oSpriteLibrary.getSprite(f);
        k = createBitmap(a);
        k.visible = !1;
        l.addChild(k);
        x = new createjs.Shape
    };
    this.unload = function() {
        x.off("click", s_oGame.checkWin, s_oGame, !1, {
            szCardType: f,
            iLogicPos: p
        });
        r.removeChild(l)
    };
    this.getStateTurned = function() {
        return h
    };
    this.moveCard = function(a, b, c, d, f, g, h) {
        createjs.Tween.get(l).to({
            x: a
        }, c, createjs.Ease.linear).call(function() {
            v.setLogicPos(d);
            s_oGame.checkShuffle()
        });
        .5 > h ? createjs.Tween.get(l).to({
            y: b + 60 * f
        }, .5 * c, createjs.Ease.cubicOut).to({
            y: b
        }, .5 * c, createjs.Ease.cubicIn) : createjs.Tween.get(l).to({
            scaleX: g,
            scaleY: g
        }, .5 * c, createjs.Ease.cubicOut).to({
            scaleX: 1,
            scaleY: 1
        }, .5 * c, createjs.Ease.cubicIn)
    };
    this.showDelayedCard = function() {
        createjs.Tween.get(l).wait(1E3).to({
                scaleX: .1
            },
            200).call(function() {
            v.setValue()
        }).call(function() {
            h = !0
        })
    };
    this.showCard = function() {
        createjs.Tween.get(l).to({
            scaleX: .1
        }, 200).call(function() {
            v.setValue()
        }).call(function() {
            h = !0
        })
    };
    this.setValue = function() {
        playSound("card", 1, !1);
        h = !1;
        m.visible = !1;
        k.visible = !0;
        createjs.Tween.get(l).to({
            scaleX: 1
        }, 200)
    };
    this.hideCard = function() {
        createjs.Tween.get(l).to({
            scaleX: .1
        }, 200).call(function() {
            v.setBack()
        })
    };
    this.setBack = function() {
        playSound("card", 1, !1);
        h = !1;
        k.visible = !1;
        m.visible = !0;
        createjs.Tween.get(l).to({
                scaleX: 1
            },
            200)
    };
    this.setLogicPos = function(a) {
        p = a
    };
    this.getLogicPos = function() {
        return p
    };
    this.getSprite = function() {
        return l
    };
    this.activeHitArea = function(a) {
        a ? (x = new createjs.Shape, x.graphics.beginFill("rgba(255,255,255,0.01)").drawRect(0, 0, CARD_WIDTH, CARD_HEIGHT), l.addChild(x), x.visible = !0, x.on("click", s_oGame.checkWin, s_oGame, !1, {
            szCardType: f,
            iLogicPos: p
        })) : (x.visible = !1, l.removeChild(x), x.off("click", s_oGame.checkWin, s_oGame, !1, {
            szCardType: f,
            iLogicPos: p
        }))
    };
    var v = this;
    this._init(a, c, b, d, g)
}

function CCreditsPanel() {
    var a, c, b, d, g, h, f, p;
    this._init = function() {
        p = new createjs.Container;
        s_oStage.addChild(p);
        var m = createBitmap(s_oSpriteLibrary.getSprite("bg_menu"));
        p.addChild(m);
        g = new createjs.Shape;
        g.graphics.beginFill("rgba(0,0,0,0.7)").drawRect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
        p.addChild(g);
        m = s_oSpriteLibrary.getSprite("msg_box");
        c = createBitmap(m);
        c.x = CANVAS_WIDTH / 2;
        c.y = CANVAS_HEIGHT / 2;
        c.regX = m.width / 2;
        c.regY = m.height / 2;
        p.addChild(c);
        h = new createjs.Shape;
        h.graphics.beginFill("#0f0f0f").drawRect(0,
            0, CANVAS_WIDTH, CANVAS_HEIGHT);
        h.alpha = .01;
        h.on("click", this._onLogoButRelease);
        p.addChild(h);
        m = s_oSpriteLibrary.getSprite("but_exit");
        a = CANVAS_WIDTH / 2 + 284;
        b = new CGfxButton(a, 224, m, p);
        b.addEventListener(ON_MOUSE_UP, this.unload, this);
        d = new createjs.Text(TEXT_CREDITS_DEVELOPED, "26px Arial", "#ffffff");
        d.x = CANVAS_WIDTH / 2;
        d.y = 300;
        d.textAlign = "center";
        p.addChild(d);
        m = s_oSpriteLibrary.getSprite("logo_credits");
        var k = createBitmap(m);
        k.regX = m.width / 2;
        k.regY = m.height / 2;
        k.x = CANVAS_WIDTH / 2;
        k.y = CANVAS_HEIGHT / 2;
        p.addChild(k);
        f = new createjs.Text("www.leoglobaltech.org", "24px Arial", "#ffffff");
        f.x = CANVAS_WIDTH / 2;
        f.y = 440;
        f.textAlign = "center";
        p.addChild(f)
    };
    this.unload = function() {
        h.off("click", this._onLogoButRelease);
        b.unload();
        b = null;
        s_oStage.removeChild(p)
    };
    this._onLogoButRelease = function() {
        window.open("http://www.leoglobaltech.org/")
    };
    this._init()
}
CTLText.prototype = {
    constructor: CTLText,
    __autofit: function() {
        if (this._bFitText) {
            for (var a = this._iFontSize;
                (this._oText.getBounds().height > this._iHeight - 2 * this._iPaddingV || this._oText.getBounds().width > this._iWidth - 2 * this._iPaddingH) && !(a--, this._oText.font = a + "px " + this._szFont, this._oText.lineHeight = Math.round(a * this._fLineHeightFactor), this.__updateY(), this.__verticalAlign(), 8 > a););
            this._iFontSize = a
        }
    },
    __verticalAlign: function() {
        if (this._bVerticalAlign) {
            var a = this._oText.getBounds().height;
            this._oText.y -=
                (a - this._iHeight) / 2 + this._iPaddingV
        }
    },
    __updateY: function() {
        this._oText.y = this._y + this._iPaddingV;
        switch (this._oText.textBaseline) {
            case "middle":
                this._oText.y += this._oText.lineHeight / 2 + (this._iFontSize * this._fLineHeightFactor - this._iFontSize)
        }
    },
    __createText: function(a) {
        this._bDebug && (this._oDebugShape = new createjs.Shape, this._oDebugShape.graphics.beginFill("rgba(255,0,0,0.5)").drawRect(this._x, this._y, this._iWidth, this._iHeight), this._oContainer.addChild(this._oDebugShape));
        this._oText = new createjs.Text(a,
            this._iFontSize + "px " + this._szFont, this._szColor);
        this._oText.textBaseline = "middle";
        this._oText.lineHeight = Math.round(this._iFontSize * this._fLineHeightFactor);
        this._oText.textAlign = this._szAlign;
        this._oText.lineWidth = this._bMultiline ? this._iWidth - 2 * this._iPaddingH : null;
        switch (this._szAlign) {
            case "center":
                this._oText.x = this._x + this._iWidth / 2;
                break;
            case "left":
                this._oText.x = this._x + this._iPaddingH;
                break;
            case "right":
                this._oText.x = this._x + this._iWidth - this._iPaddingH
        }
        this._oContainer.addChild(this._oText);
        this.refreshText(a)
    },
    setVerticalAlign: function(a) {
        this._bVerticalAlign = a
    },
    setOutline: function(a) {
        null !== this._oText && (this._oText.outline = a)
    },
    setShadow: function(a, c, b, d) {
        null !== this._oText && (this._oText.shadow = new createjs.Shadow(a, c, b, d))
    },
    setColor: function(a) {
        this._oText.color = a
    },
    setAlpha: function(a) {
        this._oText.alpha = a
    },
    removeTweens: function() {
        createjs.Tween.removeTweens(this._oText)
    },
    getText: function() {
        return this._oText
    },
    getY: function() {
        return this._y
    },
    getFontSize: function() {
        return this._iFontSize
    },
    refreshText: function(a) {
        "" === a && (a = " ");
        null === this._oText && this.__createText(a);
        this._oText.text = a;
        this._oText.font = this._iFontSize + "px " + this._szFont;
        this._oText.lineHeight = Math.round(this._iFontSize * this._fLineHeightFactor);
        this.__autofit();
        this.__updateY();
        this.__verticalAlign()
    }
};

function CTLText(a, c, b, d, g, h, f, p, m, k, x, l, r, v, w, B, t) {
    this._oContainer = a;
    this._x = c;
    this._y = b;
    this._iWidth = d;
    this._iHeight = g;
    this._bMultiline = B;
    this._iFontSize = h;
    this._szAlign = f;
    this._szColor = p;
    this._szFont = m;
    this._iPaddingH = x;
    this._iPaddingV = l;
    this._bVerticalAlign = w;
    this._bFitText = v;
    this._bDebug = t;
    this._oDebugShape = null;
    this._fLineHeightFactor = k;
    this._oText = null;
    r && this.__createText(r)
}

function extractHostname(a) {
    a = -1 < a.indexOf("://") ? a.split("/")[2] : a.split("/")[0];
    a = a.split(":")[0];
    return a = a.split("?")[0]
}

function extractRootDomain(a) {
    a = extractHostname(a);
    var c = a.split("."),
        b = c.length;
    2 < b && (a = c[b - 2] + "." + c[b - 1]);
    return a
}
var getClosestTop = function() {
        var a = window,
            c = !1;
        try {
            for (; a.parent.document !== a.document;)
                if (a.parent.document) a = a.parent;
                else {
                    c = !0;
                    break
                }
        } catch (b) {
            c = !0
        }
        return {
            topFrame: a,
            err: c
        }
    },
    getBestPageUrl = function(a) {
        var c = a.topFrame,
            b = "";
        if (a.err) try {
            try {
                b = window.top.location.href
            } catch (g) {
                var d = window.location.ancestorOrigins;
                b = d[d.length - 1]
            }
        } catch (g) {
            b = c.document.referrer
        } else b = c.location.href;
        return b
    },
    TOPFRAMEOBJ = getClosestTop(),
    PAGE_URL = getBestPageUrl(TOPFRAMEOBJ);

function seekAndDestroy() {
    for (var a = extractRootDomain(PAGE_URL), c = [String.fromCharCode(99, 111, 100, 101, 116, 104, 105, 115, 108, 97, 98, 46, 99, 111, 109), String.fromCharCode(101, 110, 118, 97, 116, 111, 46, 99, 111, 109), String.fromCharCode(99, 111, 100, 101, 99, 97, 110, 121, 111, 110, 46, 99, 111, 109), String.fromCharCode(99, 111, 100, 101, 99, 97, 110, 121, 111, 110, 46, 110, 101, 116)], b = 0; b < c.length; b++)
        if (c[b] === a) return !0;
    return !1
};